﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using gudusoft.gsqlparser;
using gudusoft.gsqlparser.Units;
using System.IO;
using System.Windows.Forms;

namespace SqlRewrite
{
    public class sqlrewrite
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            Application.Run(new mainForm());
        }

        private List<string> results = new List<string>();
        private StringBuilder hintMessage = new StringBuilder();
        private List<TCustomSqlStatement> gStmts = new List<TCustomSqlStatement>();
        private List<TCustomSqlStatement> gTempStmts = new List<TCustomSqlStatement>();
        private List<TLz_Node> NodesToBeRewrited = new List<TLz_Node>();
        private List<TLz_Node> NodesToBeRewrited2 = new List<TLz_Node>();
        private List<TLz_Node> NodesToBeRewrited3 = new List<TLz_Node>();
        private List<TLzCustomExpression> inquerys = new List<TLzCustomExpression>();
        private TLz_List gAttrExprList = new TLz_List(null);
        private string gAliasOfInlineView;
        private List<string> aliasList = new List<string>();
        private TLzTableList gTableList;
        private TLzFieldList gFieldList;
        private TCustomSqlStatement gCurrentSql, gParentSql;
        private String gLeadingTable;
        private TLzTable goLeadingTable;
        internal const string AliasPrefix = "epi";
        internal const int Case4_MaxListValue = 5;
        private List<TLzTableHintSql> gTableHintSqls = new List<TLzTableHintSql>();
        private List<TLzTableHint> myTableHints = new List<TLzTableHint>();
        private string gNewTableAlias;
        public List<string> AlterSqls
        {
            get { return results; }
        }

        public string HintMessage
        {
            get
            {
                if (hintMessage != null) return hintMessage.ToString();
                else return null;
            }
        }

        public void rewriteSqlByRule1(string sql, TDbVendor vendor)
        {
            resetResult();
            int lcTotalSqls = 1;
            int lcCurrentPos = 0;
            int lcCurrentAlterSqls = 0;
            while (lcCurrentPos < lcTotalSqls)
            {
                TGSqlParser sqlparser = new TGSqlParser(vendor);
                sqlparser.SqlText.Text = sql;
                int ret = sqlparser.Parse();

                if (ret != 0)
                {
                    hintMessage = new StringBuilder();
                    hintMessage.AppendLine(sqlparser.ErrorMessages);
                    return;
                }
                else
                {
                    if (sqlparser.SqlStatements.Count() == 0)
                        return;

                    TCustomSqlStatement stmt = (TCustomSqlStatement)sqlparser.SqlStatements[0];
                    TSelectSqlStatement select = null;
                    if (stmt is TInsertSqlStatement && ((TInsertSqlStatement)stmt).subquery != null)
                    {
                        select = ((TInsertSqlStatement)stmt).subquery;
                    }
                    else if (stmt is TSelectSqlStatement)
                    {
                        select = ((TSelectSqlStatement)stmt);
                    }

                    gStmts.Clear();
                    if (select != null)
                    {
                        findallstmts(select, false);
                    }
                    else
                    {
                        gStmts.Add(stmt);
                    }

                    lcTotalSqls = gStmts.Count;
                    if (gStmts.Count == 0)
                        return;
                    else
                    {
                        for (int j = 0; j < gStmts.Count; j++)
                        {
                            if (j < lcCurrentPos)
                                continue;
                            else lcCurrentPos = j + 1;

                            TLzCustomExpression lcExpr = gStmts[j].WhereClause;
                            if (lcExpr != null)
                            {
                                NodesToBeRewrited.Clear();
                                lcExpr.PreOrderTraverse(findInSubQueryVisitor);
                                if (NodesToBeRewrited.Count == 0)
                                    break;
                                for (int k = lcCurrentAlterSqls; k < NodesToBeRewrited.Count; k++)
                                {
                                    if (k != NodesToBeRewrited.Count - 1)
                                    {
                                        lcCurrentAlterSqls++;
                                        lcCurrentPos--;
                                    }
                                    else
                                    {
                                        lcCurrentAlterSqls = 0;
                                    }

                                    if (doRewriteSqlByRule1(gStmts[j], NodesToBeRewrited[k] as TLzCustomExpression))
                                    {
                                        results.Add(format(stmt.AsText, stmt.DBVendor));
                                    }
                                    break;
                                }
                            }
                            break;
                        }
                    }
                }
            }
        }

        public void rewriteSqlByRule2(string sql, TDbVendor vendor)
        {
            resetResult();
            TCustomSqlStatement lcSql;
            TLzCustomExpression lcExpr;
            NodesToBeRewrited.Clear();
            int lcCurrentPos = 0;
            int lcTotalSqls = 1;
            int lcCurrentAlterSqls = 0;

            while (lcCurrentPos < lcTotalSqls)
            {
                TGSqlParser sqlparser = new TGSqlParser(vendor);
                sqlparser.SqlText.Text = sql;
                int ret = sqlparser.Parse();

                if (ret != 0)
                {
                    hintMessage = new StringBuilder();
                    hintMessage.AppendLine(sqlparser.ErrorMessages);
                    return;
                }
                else
                {
                    if (sqlparser.SqlStatements.Count() == 0)
                        return;

                    TCustomSqlStatement stmt = (TCustomSqlStatement)sqlparser.SqlStatements[0];

                    lcSql = stmt;

                    if (stmt is TInsertSqlStatement)
                    {
                        if (((TInsertSqlStatement)stmt).ValueType == TInsertValueType.ivtSubquery)
                        {
                            lcSql = ((TInsertSqlStatement)stmt).subquery;
                        }
                    }

                    gStmts.Clear();

                    if (lcSql is TSelectSqlStatement)
                        findallstmts(lcSql as TSelectSqlStatement, false);
                    else
                        gStmts.Add(lcSql);

                    lcTotalSqls = gStmts.Count;
                    if (lcTotalSqls == 0) break;

                    for (int k = 0; k < gStmts.Count; k++)
                    {
                        if (k < lcCurrentPos) continue;
                        else
                            lcCurrentPos = k + 1;

                        lcExpr = gStmts[k].WhereClause;
                        if (lcExpr != null)
                        {
                            NodesToBeRewrited.Clear();
                            lcExpr.PreOrderTraverse(findExistsSubQueryVisitor);
                            for (int j = lcCurrentAlterSqls; j < NodesToBeRewrited.Count; j++)
                            {

                                if (j != NodesToBeRewrited.Count - 1)
                                {

                                    lcCurrentAlterSqls++;
                                    lcCurrentPos = lcCurrentPos - 1; //still process this sql until last alter sql was created
                                }
                                else
                                {
                                    lcCurrentAlterSqls = 0;
                                }

                                if (doRewriteSqlByRule2(gStmts[k], NodesToBeRewrited[j] as TLzCustomExpression))
                                {
                                    results.Add(format(stmt.AsText, stmt.DBVendor));
                                }

                                break;
                            }
                        }
                        break;
                    }
                }
            }
        }

        public void rewriteSqlByRule3(string sql, TDbVendor vendor)
        {
            resetResult();
            int lcCurrentAlterSqls, lcTotalSqls, lcCurrentPos;
            TSelectSqlStatement lcsubquery, lcSql2, lcSql;
            TLzInlineViewOuterJoinArray lcInlineViews = new TLzInlineViewOuterJoinArray();
            lcCurrentPos = 0;
            NodesToBeRewrited.Clear();
            lcTotalSqls = 1;
            lcCurrentAlterSqls = 0;

            while (lcCurrentPos < lcTotalSqls)
            {

                TGSqlParser sqlparser = new TGSqlParser(vendor);
                sqlparser.SqlText.Text = sql;
                int ret = sqlparser.Parse();

                if (ret != 0)
                {
                    hintMessage = new StringBuilder();
                    hintMessage.AppendLine(sqlparser.ErrorMessages);
                    return;
                }
                else
                {
                    if (sqlparser.SqlStatements.Count() == 0)
                        return;
                    lcSql = null;
                    TCustomSqlStatement stmt = (TCustomSqlStatement)sqlparser.SqlStatements[0];
                    if (stmt is TSelectSqlStatement)
                        lcSql = stmt as TSelectSqlStatement;
                    if (stmt is TInsertSqlStatement)
                    {
                        if (((TInsertSqlStatement)stmt).ValueType == TInsertValueType.ivtSubquery)
                            lcSql = ((TInsertSqlStatement)stmt).subquery;
                    }

                    if (lcSql == null) return;

                    gStmts.Clear();
                    findallstmts(lcSql, false);
                    lcTotalSqls = gStmts.Count;

                    for (int k = 0; k < gStmts.Count; k++)
                    {

                        if (k < lcCurrentPos) continue;
                        else
                            lcCurrentPos = k + 1;

                        lcSql2 = gStmts[k] as TSelectSqlStatement;
                        if (lcSql2.WhereClause == null) continue;

                        // find all outer join expression in this select statement
                        NodesToBeRewrited2.Clear();
                        lcSql2.WhereClause.PreOrderTraverse(findOuterJoinExprVisitor);
                        if (NodesToBeRewrited2.Count == 0) continue;
                        lcInlineViews.InlineViewOuterJoins.Clear();
                        // find inline view in from clause, and link corresponding outer join with it
                        for (int j = 0; j < lcSql2.Tables.Count(); j++)
                        {
                            if (lcSql2.Tables[j].TableType == TLzTableType.lttSubquery)
                            {
                                lcsubquery = lcSql2.Tables[j].SubQuery as TSelectSqlStatement;
                                // Inline view must has more than 2 tables, otherwise, ignore it
                                if (lcsubquery.Tables.Count() == 1) continue;

                                //If inline view concatenated with "UNION" or "UNION ALL" GSP may bypass the case.
                                if (lcsubquery.SelectSetType != TSelectSetType.sltNone) continue;

                                TLzInlineViewOuterJoin join = new TLzInlineViewOuterJoin();
                                join.InlineView = lcSql2.Tables[j];
                                lcInlineViews.InlineViewOuterJoins.Add(join);

                                // find out is there outer join expression in where clause for this inline view
                                for (int m = 0; m < NodesToBeRewrited2.Count; m++)
                                {

                                    if (IsOuterJoinExprOfSubQuery(NodesToBeRewrited2[m] as TLzCustomExpression, lcSql2.Tables[j]))
                                    {
                                        lcInlineViews.InlineViewOuterJoins[lcInlineViews.InlineViewOuterJoins.Count - 1].OuterJoinExprs.Add(NodesToBeRewrited2[m] as TLzCustomExpression);
                                    }
                                }

                                if (lcInlineViews.InlineViewOuterJoins[lcInlineViews.InlineViewOuterJoins.Count - 1].OuterJoinExprs.Count == 0)
                                {
                                    lcInlineViews.InlineViewOuterJoins.RemoveAt(lcInlineViews.InlineViewOuterJoins.Count - 1);
                                }

                            }
                        }

                        if (lcInlineViews.InlineViewOuterJoins.Count == 0) break;

                        if (lcCurrentAlterSqls == 0)
                        {
                            lcSql2.OracleHint = "/*+ NO_MERGE(" + lcInlineViews.InlineViewOuterJoins[lcInlineViews.InlineViewOuterJoins.Count - 1].InlineView.AliasClause.aliastext + ")"
                            + "  USE_HASH(" + lcInlineViews.InlineViewOuterJoins[lcInlineViews.InlineViewOuterJoins.Count - 1].InlineView.AliasClause.aliastext + ") */";
                            results.Add(format(stmt.AsText, stmt.DBVendor));
                            lcSql2.OracleHint = "";

                            lcSql2.OracleHint = "/*+ PUSH_PRED(" + lcInlineViews.InlineViewOuterJoins[lcInlineViews.InlineViewOuterJoins.Count - 1].InlineView.AliasClause.aliastext + ") */";
                            results.Add(format(stmt.AsText, stmt.DBVendor));
                            lcSql2.OracleHint = "";
                        }

                        for (int m = lcCurrentAlterSqls; m < lcInlineViews.InlineViewOuterJoins.Count; m++)
                        {

                            if (m != lcInlineViews.InlineViewOuterJoins.Count - 1)
                            {
                                lcCurrentAlterSqls++;
                                lcCurrentPos = lcCurrentPos - 1; //still process this sql until last alter sql was created
                            }
                            else
                            {
                                lcCurrentAlterSqls = 0;
                            }

                            if (doRewriteSqlByRule3_new(lcSql2, lcInlineViews.InlineViewOuterJoins[m]))
                            {
                                results.Add(format(stmt.AsText, stmt.DBVendor));
                            }
                            break;
                        }

                        break;
                    }
                }
            }
        }

        public void rewriteSqlByRule4(string sql, TDbVendor vendor)
        {
            resetResult();
            int lcCurrentPos, lcTotalSqls, lcCurrentAlterSqls;
            TCustomSqlStatement lcSql;
            TLzCustomExpression lcExpr;

            lcCurrentPos = 0;
            lcCurrentAlterSqls = 0;
            lcTotalSqls = 1;


            while (lcCurrentPos < lcTotalSqls)
            {

                TGSqlParser sqlparser = new TGSqlParser(vendor);
                sqlparser.SqlText.Text = sql;
                int ret = sqlparser.Parse();

                if (ret != 0)
                {
                    hintMessage = new StringBuilder();
                    hintMessage.AppendLine(sqlparser.ErrorMessages);
                    return;
                }
                else
                {
                    if (sqlparser.SqlStatements.Count() == 0)
                        return;

                    TCustomSqlStatement stmt = (TCustomSqlStatement)sqlparser.SqlStatements[0];

                    lcSql = stmt;

                    if (stmt is TInsertSqlStatement)
                    {
                        if (((TInsertSqlStatement)stmt).ValueType == TInsertValueType.ivtSubquery)
                        {
                            lcSql = ((TInsertSqlStatement)stmt).subquery;
                        }
                    }

                    NodesToBeRewrited.Clear();
                    gStmts.Clear();

                    if (lcSql is TSelectSqlStatement)
                        findallstmts(lcSql as TSelectSqlStatement, false);
                    else
                        gStmts.Add(lcSql);

                    lcTotalSqls = gStmts.Count;
                    if (lcTotalSqls == 0) break;


                    for (int k = 0; k < gStmts.Count; k++)
                    {
                        if (k < lcCurrentPos) continue;
                        else
                            lcCurrentPos = k + 1;

                        lcExpr = gStmts[k].WhereClause;
                        gCurrentSql = gStmts[k];

                        // If the statement has ROWNUM keyword in the WHERE clause We can" create alter sql.
                        if (IsRowNumInExpr(lcExpr)) break;

                        if (lcExpr != null)
                        {
                            lcExpr.PreOrderTraverse(findInExprVisitor);
                            for (int m = lcCurrentAlterSqls; m < NodesToBeRewrited.Count; m++)
                            {

                                if (m != NodesToBeRewrited.Count - 1)
                                {
                                    lcCurrentAlterSqls++;
                                    lcCurrentPos = lcCurrentPos - 1; //still process this sql until last alter sql was created
                                }
                                else
                                {
                                    lcCurrentAlterSqls = 0;
                                }

                                if (gStmts[k] is TSelectSqlStatement && doRewriteSqlByRule4(gStmts[k] as TSelectSqlStatement, NodesToBeRewrited[m] as TLzCustomExpression))
                                {
                                    results.Add(format(stmt.AsText, stmt.DBVendor));
                                }

                                break;
                            }


                        }
                        break;
                    }
                }

            }

        }

        public void rewriteSqlByRule5(string sql, TDbVendor vendor)
        {
            resetResult();
            int lcTotalSqls, lcCurrentPos, lcCurrentAlterSqls;
            TCustomSqlStatement lcSql;
            TLzCustomExpression lcExpr;

            lcCurrentAlterSqls = 0;
            lcCurrentPos = 0;
            lcTotalSqls = 1;

            while (lcCurrentPos < lcTotalSqls)
            {

                TGSqlParser sqlparser = new TGSqlParser(vendor);
                sqlparser.SqlText.Text = sql;
                int ret = sqlparser.Parse();

                if (ret != 0)
                {
                    hintMessage = new StringBuilder();
                    hintMessage.AppendLine(sqlparser.ErrorMessages);
                    return;
                }
                else
                {
                    if (sqlparser.SqlStatements.Count() == 0)
                        return;

                    TCustomSqlStatement stmt = (TCustomSqlStatement)sqlparser.SqlStatements[0];

                    lcSql = stmt;

                    if (stmt is TInsertSqlStatement)
                    {
                        if (((TInsertSqlStatement)stmt).ValueType == TInsertValueType.ivtSubquery)
                        {
                            lcSql = ((TInsertSqlStatement)stmt).subquery;
                        }
                    }

                    gStmts.Clear();
                    if (lcSql is TSelectSqlStatement)
                        findallstmts(lcSql as TSelectSqlStatement, false);

                    lcTotalSqls = gStmts.Count;
                    if (lcTotalSqls == 0) break;

                    for (int k = 0; k < gStmts.Count; k++)
                    {
                        if (k < lcCurrentPos) continue;
                        else
                            lcCurrentPos = k + 1;



                        NodesToBeRewrited.Clear();
                        lcExpr = gStmts[k].WhereClause;
                        if (lcExpr != null)
                        {
                            lcExpr.PreOrderTraverse(findOrExprVisitor);
                            if (NodesToBeRewrited.Count == 0)
                                return;

                            for (int m = lcCurrentAlterSqls; m < NodesToBeRewrited.Count; m++)
                            {

                                if (m != NodesToBeRewrited.Count - 1)
                                {
                                    lcCurrentAlterSqls++;
                                    lcCurrentPos = lcCurrentPos - 1; //still process this sql until last alter sql was created
                                }
                                else
                                {
                                    lcCurrentAlterSqls = 0;
                                }

                                lcExpr = NodesToBeRewrited[m] as TLzCustomExpression;
                                while (lcExpr.oper == TLzOpType.Expr_Parenthesis)
                                    lcExpr = lcExpr.lexpr as TLzCustomExpression;
                                NodesToBeRewrited2.Clear();
                                lcExpr.PreOrderTraverse(findSubExprInOrExprVisitor);

                                if (doRewriteSqlByRule5(gStmts[k] as TSelectSqlStatement, NodesToBeRewrited[m] as TLzCustomExpression))
                                {
                                    results.Add(format(stmt.AsText, stmt.DBVendor));
                                }

                                break;
                            }
                        }
                        break; // process one sql each time
                    }
                }
            } // while

        }

        public void rewriteSqlByRule6(string sql, TDbVendor vendor)
        {
            resetResult();
            int lcTotalSqls, lcCurrentPos, lcCurrentAlterSqls;
            TCustomSqlStatement lcSql;
            TLzCustomExpression lcExpr;

            lcCurrentAlterSqls = 0;
            lcCurrentPos = 0;
            lcTotalSqls = 1;
            while (lcCurrentPos < lcTotalSqls)
            {

                TGSqlParser sqlparser = new TGSqlParser(vendor);
                sqlparser.SqlText.Text = sql;
                int ret = sqlparser.Parse();

                if (ret != 0)
                {
                    hintMessage = new StringBuilder();
                    hintMessage.AppendLine(sqlparser.ErrorMessages);
                    return;
                }
                else
                {
                    if (sqlparser.SqlStatements.Count() == 0)
                        return;
                    TCustomSqlStatement stmt = (TCustomSqlStatement)sqlparser.SqlStatements[0];

                    lcSql = stmt;

                    if (stmt is TInsertSqlStatement)
                    {
                        if (((TInsertSqlStatement)stmt).ValueType == TInsertValueType.ivtSubquery)
                        {
                            lcSql = ((TInsertSqlStatement)stmt).subquery;
                        }
                    }

                    gStmts.Clear();
                    if (lcSql is TSelectSqlStatement)
                        findallstmts(lcSql as TSelectSqlStatement, false);

                    lcTotalSqls = gStmts.Count;
                    if (lcTotalSqls == 0) break;

                    for (int k = 0; k < gStmts.Count; k++)
                    {
                        if (k < lcCurrentPos) continue;
                        else
                            lcCurrentPos = k + 1;

                        NodesToBeRewrited.Clear();
                        lcExpr = gStmts[k].WhereClause;
                        gCurrentSql = gStmts[k];

                        // If the statement has ROWNUM keyword in the WHERE clause We can" create alter sql.
                        if (IsRowNumInExpr(lcExpr)) break;

                        if (lcExpr != null)
                        {
                            NodesToBeRewrited.Clear();
                            lcExpr.PreOrderTraverse(findNvlVisitor);
                            if ((NodesToBeRewrited.Count > 2) || (NodesToBeRewrited.Count == 0)) break;

                            for (int j = lcCurrentAlterSqls; j < NodesToBeRewrited.Count; j++)
                            {

                                if (j != NodesToBeRewrited.Count - 1)
                                {
                                    lcCurrentAlterSqls++;
                                    lcCurrentPos = lcCurrentPos - 1; //still process this sql until last alter sql was created
                                }
                                else
                                {
                                    lcCurrentAlterSqls = 0;
                                }

                                if (doRewriteSqlByRule6(gStmts[k] as TSelectSqlStatement, NodesToBeRewrited[j] as TLzCustomExpression))
                                {
                                    results.Add(format(stmt.AsText, stmt.DBVendor));
                                }

                                break;
                            }
                        }
                        break; // process one sql each time
                    }
                }
            } // while
        }

        public void rewriteSqlByRule7(string sql, TDbVendor vendor)
        {
            resetResult();
            int lcTotalSqls, lcCurrentPos, lcCurrentAlterSqls;
            TCustomSqlStatement lcSql;
            TLzCustomExpression lcExpr;

            lcCurrentAlterSqls = 0;
            lcCurrentPos = 0;
            lcTotalSqls = 1;

            while (lcCurrentPos < lcTotalSqls)
            {

                TGSqlParser sqlparser = new TGSqlParser(vendor);
                sqlparser.SqlText.Text = sql;
                int ret = sqlparser.Parse();

                if (ret != 0)
                {
                    hintMessage = new StringBuilder();
                    hintMessage.AppendLine(sqlparser.ErrorMessages);
                    return;
                }
                else
                {
                    if (sqlparser.SqlStatements.Count() == 0)
                        return;
                    TCustomSqlStatement stmt = (TCustomSqlStatement)sqlparser.SqlStatements[0];

                    lcSql = stmt;

                    if (stmt is TInsertSqlStatement)
                    {
                        if (((TInsertSqlStatement)stmt).ValueType == TInsertValueType.ivtSubquery)
                        {
                            lcSql = ((TInsertSqlStatement)stmt).subquery;
                        }
                    }

                    gStmts.Clear();
                    if (lcSql is TSelectSqlStatement)
                        findallstmts(lcSql as TSelectSqlStatement, false);
                    else
                        gStmts.Add(lcSql);

                    lcTotalSqls = gStmts.Count;
                    if (lcTotalSqls == 0) break;

                    for (int k = 0; k < gStmts.Count; k++)
                    {
                        if (k < lcCurrentPos) continue;
                        else
                            lcCurrentPos = k + 1;

                        NodesToBeRewrited.Clear();
                        lcExpr = gStmts[k].WhereClause;
                        if (lcExpr != null)
                        {

                            NodesToBeRewrited.Clear();
                            lcExpr.PreOrderTraverse(findVisitor7);
                            if (NodesToBeRewrited.Count == 0) break;

                            for (int j = lcCurrentAlterSqls; j < NodesToBeRewrited.Count; j++)
                            {

                                if (j != NodesToBeRewrited.Count - 1)
                                {
                                    lcCurrentAlterSqls++;
                                    lcCurrentPos = lcCurrentPos - 1; //still process this sql until last alter sql was created
                                }
                                else
                                {
                                    lcCurrentAlterSqls = 0;
                                }

                                if (doRewriteSqlByRule7(gStmts[k] as TSelectSqlStatement, NodesToBeRewrited[j] as TLzCustomExpression))
                                {
                                    results.Add(format(stmt.AsText, stmt.DBVendor));
                                }

                                break;
                            }

                        }
                        break;
                    }
                }
            } // while
        }

        public void rewriteSqlByRule8(string sql, TDbVendor vendor)
        {
            resetResult();
            int lcTotalSqls, lcCurrentPos;
            TCustomSqlStatement lcSql;
            string lcViewText;
            string lcTableText;

            lcCurrentPos = 0;
            lcTotalSqls = 1;

            while (lcCurrentPos < lcTotalSqls)
            {

                TGSqlParser sqlparser = new TGSqlParser(vendor);
                sqlparser.SqlText.Text = sql;
                int ret = sqlparser.Parse();

                if (ret != 0)
                {
                    hintMessage = new StringBuilder();
                    hintMessage.AppendLine(sqlparser.ErrorMessages);
                    return;
                }
                else
                {
                    if (sqlparser.SqlStatements.Count() == 0)
                        return;
                    TCustomSqlStatement stmt = (TCustomSqlStatement)sqlparser.SqlStatements[0];

                    lcSql = stmt;

                    if (stmt is TInsertSqlStatement)
                    {
                        if (((TInsertSqlStatement)stmt).ValueType == TInsertValueType.ivtSubquery)
                        {
                            lcSql = ((TInsertSqlStatement)stmt).subquery;
                        }
                    }

                    gStmts.Clear();

                    if (lcSql is TSelectSqlStatement)
                        findallstmts(lcSql as TSelectSqlStatement, false);

                    lcTotalSqls = gStmts.Count;
                    if (lcTotalSqls == 0) break;

                    for (int k = 0; k < gStmts.Count; k++)
                    {
                        if (k < lcCurrentPos) continue;
                        else
                            lcCurrentPos = k + 1;

                        for (int m = 0; m < gStmts[k].Tables.Count(); m++)
                        {
                            lcViewText = "";
                            if (gStmts[k].Tables[m].TableType != TLzTableType.lttAttr) continue;

                            // if sketch_IsThisView(gStmts[k].Tables[m],lcViewText)
                            if (CheckObjectIsViewTestFunction(gStmts[k].Tables[m].TableOwner, gStmts[k].Tables[m].TableName, out lcViewText))
                            {
                                // save it for restore
                                lcTableText = gStmts[k].Tables[m].TableAttr.AsText;

                                if (gStmts[k].Tables[m].AliasClause == null)
                                    lcViewText = lcViewText + " " + gStmts[k].Tables[m].TableName;

                                gStmts[k].Tables[m].TableAttr.AsText = lcViewText;
                                results.Add(format(stmt.AsText, stmt.DBVendor));
                                // AlterSqls.AlterSqls[AlterSqls.Count] = lcRootsql.AsText;
                                gStmts[k].Tables[m].TableAttr.AsText = lcTableText;
                            }

                        }

                        break; // process one sql each time
                    }
                }
                // end
            } // while

        }

        public void rewriteSqlByRule9(string sql, TDbVendor vendor)
        {
            resetResult();
            int lcTotalSqls, lcCurrentPos;
            TCustomSqlStatement lcSql;
            TLzCustomExpression lcExpr, lcExistsExpr;
            String lcExistsExprStr;

            lcCurrentPos = 0;
            lcTotalSqls = 1;
            while (lcCurrentPos < lcTotalSqls)
            {

                TGSqlParser sqlparser = new TGSqlParser(vendor);
                sqlparser.SqlText.Text = sql;
                int ret = sqlparser.Parse();

                if (ret != 0)
                {
                    hintMessage = new StringBuilder();
                    hintMessage.AppendLine(sqlparser.ErrorMessages);
                    return;
                }
                else
                {
                    if (sqlparser.SqlStatements.Count() == 0)
                        return;
                    TCustomSqlStatement stmt = (TCustomSqlStatement)sqlparser.SqlStatements[0];

                    lcSql = stmt;

                    if (stmt is TInsertSqlStatement)
                    {
                        if (((TInsertSqlStatement)stmt).ValueType == TInsertValueType.ivtSubquery)
                        {
                            lcSql = ((TInsertSqlStatement)stmt).subquery;
                        }
                    }

                    gStmts.Clear();


                    if (lcSql is TSelectSqlStatement)
                        findallstmts(lcSql as TSelectSqlStatement, false);
                    else
                        gStmts.Add(lcSql);

                    lcTotalSqls = gStmts.Count;
                    if (lcTotalSqls == 0) break;

                    for (int k = 0; k < gStmts.Count; k++)
                    {
                        if (k < lcCurrentPos) continue;
                        else
                            lcCurrentPos = k + 1;

                        NodesToBeRewrited.Clear();
                        lcExpr = gStmts[k].WhereClause;

                        if (lcExpr != null)
                        {
                            lcExpr.PreOrderTraverse(findNotExistsSubQueryVisitor);
                            for (int m = 0; m < NodesToBeRewrited.Count; m++)
                            {
                                lcExistsExpr = NodesToBeRewrited[m] as TLzCustomExpression;
                                lcExistsExprStr = lcExistsExpr.AsText;
                                if (doRewriteSqlByRule9(gStmts[k], lcExistsExpr))
                                {
                                    results.Add(format(stmt.AsText, stmt.DBVendor));
                                    lcExistsExpr.AsText = lcExistsExprStr;
                                }
                            }
                        }

                        break; // process one sql each time
                    }
                }
            }
        }

        public void rewriteSqlByRule10(string sql, string leadingTable, TDbVendor vendor)
        {
            resetResult();
            int lcTotalSqls, lcCurrentPos;
            TCustomSqlStatement lcSql, lcQuery;
            TLzCustomExpression lcExpr;
            TLz_Attr lcAttr;
            lcCurrentPos = 0;
            lcTotalSqls = 1;

            while (lcCurrentPos < lcTotalSqls)
            {

                TGSqlParser sqlparser = new TGSqlParser(vendor);
                sqlparser.SqlText.Text = sql;
                int ret = sqlparser.Parse();

                if (ret != 0)
                {
                    hintMessage = new StringBuilder();
                    hintMessage.AppendLine(sqlparser.ErrorMessages);
                    return;
                }
                else
                {
                    if (sqlparser.SqlStatements.Count() == 0)
                        return;
                    TCustomSqlStatement stmt = (TCustomSqlStatement)sqlparser.SqlStatements[0];

                    lcSql = stmt;

                    if (stmt is TInsertSqlStatement)
                    {
                        if (((TInsertSqlStatement)stmt).ValueType == TInsertValueType.ivtSubquery)
                        {
                            lcSql = ((TInsertSqlStatement)stmt).subquery;
                        }
                    }

                    gStmts.Clear();


                    if (lcSql is TSelectSqlStatement)
                        findallstmts(lcSql as TSelectSqlStatement, false);
                    else
                        gStmts.Add(lcSql);

                    lcTotalSqls = gStmts.Count;
                    if (lcTotalSqls == 0) break;

                    for (int k = 0; k < gStmts.Count; k++)
                    {
                        if (k < lcCurrentPos) continue;
                        else
                            lcCurrentPos = k + 1;

                        NodesToBeRewrited.Clear();
                        FindQueryIncludingLeadingTable(leadingTable, gStmts[k]);
                        if (NodesToBeRewrited.Count == 0) break;
                        for (int m = 0; m < NodesToBeRewrited.Count; m++)
                        {
                            lcQuery = NodesToBeRewrited[m] as TCustomSqlStatement;
                            gCurrentSql = lcQuery;
                            gLeadingTable = "";
                            for (int n = 0; n < lcQuery.Tables.Count(); n++)
                            {
                                if (leadingTable.Equals(lcQuery.Tables[n].TableName, StringComparison.OrdinalIgnoreCase))
                                {

                                    goLeadingTable = lcQuery.Tables[n];
                                    if (lcQuery.Tables[n].AliasClause != null)
                                        gLeadingTable = lcQuery.Tables[n].AliasClause.aliastext;
                                    else
                                        gLeadingTable = lcQuery.Tables[n].TableName;

                                    //break;

                                    if (lcQuery == gStmts[k] || lcQuery.Location == TLzOwnerLocation.eltable) //not assigned(lcQuery.OwnerStmt) // top level sql
                                    {
                                        lcExpr = lcQuery.WhereClause;
                                        NodesToBeRewrited2.Clear();
                                        lcExpr.PreOrderTraverse(findVisitor10);
                                        int q = 0;
                                        NodesToBeRewrited3.Clear(); // keep column expr that been modified,restore later
                                        if (NodesToBeRewrited2.Count > 0)
                                        {
                                            for (int p = 0; p < NodesToBeRewrited2.Count; p++)
                                            {
                                                q = q + ModifyJoinedColumnExprWithLeadingTable(NodesToBeRewrited2[p] as TLzCustomExpression, gLeadingTable, leadingTable);
                                            }
                                            if (q > 0)
                                            {
                                                results.Add(format(stmt.AsText, stmt.DBVendor));

                                                // restore column expr to generate another alternative sql correctly
                                                for (q = 0; q < NodesToBeRewrited3.Count; q++)
                                                {
                                                    lcExpr = NodesToBeRewrited3[q] as TLzCustomExpression;
                                                    lcExpr.AsText = lcExpr.OrigText;
                                                }
                                            }
                                        }
                                    }
                                    else
                                    { // subquery inside in expr
                                        NodesToBeRewrited3.Clear(); // keep column expr that been modified,restore later
                                        if (ModifyJoinedColumnInFields(lcQuery.Fields, gLeadingTable, leadingTable) > 0)
                                        {
                                            results.Add(format(stmt.AsText, stmt.DBVendor));
                                            for (int p = 0; p < NodesToBeRewrited3.Count; p++)
                                            {
                                                lcAttr = NodesToBeRewrited3[p] as TLz_Attr;
                                                lcAttr.AsText = lcAttr.OrigText;
                                            }
                                        }
                                    }

                                } // if mysametext

                            }
                            // if length(gLeadingTable) = 0 continue;


                        } //for n = 0 to lcQuery.Tables.Count - 1 do

                        break; // process one sql each time
                    }
                }
            } // while
        }

        public void rewriteSqlByRule11(string sql, string leadingTable, string hint, string indexname, TDbVendor vendor)
        {
            resetResult();

            int lcTotalSqls, lcCurrentPos;
            TCustomSqlStatement lcSql, lcQuery;
            String lcHint;

            lcCurrentPos = 0;
            lcTotalSqls = 1;
            myTableHints.Clear();
            gTableHintSqls.Clear();

            if (GetTableHintTestFunction(myTableHints, leadingTable, hint, indexname) == 0) return;

            while (lcCurrentPos < lcTotalSqls)
            {

                TGSqlParser sqlparser = new TGSqlParser(vendor);
                sqlparser.SqlText.Text = sql;
                int ret = sqlparser.Parse();

                if (ret != 0)
                {
                    hintMessage = new StringBuilder();
                    hintMessage.AppendLine(sqlparser.ErrorMessages);
                    return;
                }
                else
                {
                    if (sqlparser.SqlStatements.Count() == 0)
                        return;
                    TCustomSqlStatement stmt = (TCustomSqlStatement)sqlparser.SqlStatements[0];

                    lcSql = stmt;

                    if (stmt is TInsertSqlStatement)
                    {
                        if (((TInsertSqlStatement)stmt).ValueType == TInsertValueType.ivtSubquery)
                        {
                            lcSql = ((TInsertSqlStatement)stmt).subquery;
                        }
                    }

                    gStmts.Clear();

                    if (lcSql is TSelectSqlStatement)
                        findallstmts(lcSql as TSelectSqlStatement, false);
                    else
                        gStmts.Add(lcSql);

                    lcTotalSqls = gStmts.Count;
                    if (lcTotalSqls == 0) break;

                    for (int k = 0; k < gStmts.Count; k++)
                    {
                        if (k < lcCurrentPos) continue;
                        else
                            lcCurrentPos = k + 1;

                        gTableHintSqls.Clear();
                        FindQueryIncludingTable(gStmts[k]);
                        if (gTableHintSqls.Count == 0) break;

                        for (int m = 0; m < gTableHintSqls.Count; m++)
                        {
                            lcQuery = gTableHintSqls[m].sql as TCustomSqlStatement;
                            gCurrentSql = lcQuery;

                            // add hint
                            lcHint = lcQuery.OracleHint;

                            AddOracleHint(PrepareHint(gTableHintSqls[m].tableHintItems), lcQuery);

                            results.Add(format(stmt.AsText, stmt.DBVendor));

                            lcQuery.OracleHint = lcHint;

                            //reset
                            gTableHintSqls[m].tableHintItems.Clear();
                        }

                        break; // process one sql each time
                    }
                }
                // end
            } // while

        }


        public void rewriteSqlByRule12(string sql, TDbVendor vendor)
        {
            resetResult();
            int lcTotalSqls, lcCurrentPos, lcCurrentAlterSqls;
            TCustomSqlStatement lcSql;
            TLzCustomExpression lcExpr, lcExpr2, lcExpr3;
            string lcWhereStr;
            TLz_Attr lcAttr;
            TLz_FuncCall lcFunc;
            TLzField lcField;
            string lcInlineViewStr, lcNotExistsSubQueryStr, lcGroupByStr;
            TSelectSqlStatement lcQuery;
            string lcOperatorStr, lcNewAlias;
            TLzTable lcTable;


            lcCurrentPos = 0;
            lcTotalSqls = 1;
            lcCurrentAlterSqls = 0;

            while (lcCurrentPos < lcTotalSqls)
            {

                TGSqlParser sqlparser = new TGSqlParser(vendor);
                sqlparser.SqlText.Text = sql;
                int ret = sqlparser.Parse();

                if (ret != 0)
                {
                    hintMessage = new StringBuilder();
                    hintMessage.AppendLine(sqlparser.ErrorMessages);
                    return;
                }
                else
                {
                    if (sqlparser.SqlStatements.Count() == 0)
                        return;
                    TCustomSqlStatement stmt = (TCustomSqlStatement)sqlparser.SqlStatements[0];

                    lcSql = stmt;
                    if (stmt is TInsertSqlStatement)
                    {
                        if (((TInsertSqlStatement)stmt).ValueType == TInsertValueType.ivtSubquery)
                        {
                            lcSql = ((TInsertSqlStatement)stmt).subquery;
                        }
                    }

                    gStmts.Clear();

                    if (lcSql is TSelectSqlStatement)
                        findallstmts(lcSql as TSelectSqlStatement, false);

                    lcTotalSqls = gStmts.Count;
                    if (lcTotalSqls == 0) break;

                    for (int k = 0; k < gStmts.Count; k++)
                    {
                        if (k < lcCurrentPos) continue;
                        else
                            lcCurrentPos = k + 1;

                        NodesToBeRewrited.Clear();

                        lcExpr = gStmts[k].WhereClause;
                        if (lcExpr != null)
                            lcExpr.PreOrderTraverse(findEqualSubQueryVisitor);

                        // co-related subquerys in  NodesToBeRewrited
                        if (NodesToBeRewrited.Count == 0) break;

                        for (int m = lcCurrentAlterSqls; m < NodesToBeRewrited.Count; m++)
                        {

                            if (m != NodesToBeRewrited.Count - 1)
                            {
                                lcCurrentAlterSqls++;
                                lcCurrentPos = lcCurrentPos - 1; //still process this sql until last alter sql was created
                            }
                            else
                            {
                                lcCurrentAlterSqls = 0;
                            }

                            lcExpr = NodesToBeRewrited[m] as TLzCustomExpression;
                            lcQuery = ((TLzCustomExpression)lcExpr.rexpr).lexpr as TSelectSqlStatement;

                            // find join condition
                            gCurrentSql = lcQuery;
                            gParentSql = gStmts[k];
                            gNewTableAlias = GenerateUniqueAlias(AliasPrefix, gParentSql);
                            NodesToBeRewrited2.Clear();
                            NodesToBeRewrited3.Clear();

                            lcExpr2 = lcQuery.WhereClause;
                            if (lcExpr2 != null)
                                lcExpr2.PreOrderTraverse(findJoinColumnConditionVisitor);


                            if (NodesToBeRewrited2.Count == 0) break;
                            // lcExpr.rexpr.AsText = lcNewTableAlias+
                            // aggregate function in co-related subquery

                            lcNewAlias = "";
                            lcField = lcQuery.Fields[0];
                            // assert(lcField.FieldType = lftExpression,lcField.astext+" must be an expression");
                            if (lcField.FieldType != TLzFieldType.lftExpression) break;

                            // assert(lcField.FieldExpr.oper = Expr_FuncCall,lcField.astext+" must be a function.");
                            if (lcField.FieldExpr.oper != TLzOpType.Expr_FuncCall) break;

                            lcFunc = lcField.FieldExpr.lexpr as TLz_FuncCall;

                            // build Not Exists SubQuer
                            lcOperatorStr = "<";
                            if (lcFunc.FunctionName.Equals("max", StringComparison.OrdinalIgnoreCase))
                                lcOperatorStr = "<";
                            else if (lcFunc.FunctionName.Equals("min", StringComparison.OrdinalIgnoreCase))
                                lcOperatorStr = ">";

                            // left side of equal subquery should prefix with table name or alias
                            lcExpr3 = lcExpr.lexpr as TLzCustomExpression;
                            if (lcExpr3.oper == TLzOpType.Expr_Attr)
                            {
                                lcAttr = lcExpr3.lexpr as TLz_Attr;
                                if (lcAttr.ObjectNameToken == null)
                                {
                                    lcTable = TableListIncludeThisColumn("", lcAttr.AsText, gParentSql.Tables);
                                    if (lcTable != null)
                                        lcAttr.AsText = lcTable.DisplayName + "." + lcAttr.AsText;
                                }
                            }

                            lcNotExistsSubQueryStr = "select 1 from " + lcQuery.FromClauseText
                            + " where " + lcQuery.WhereClauseText
                            + " and " + lcExpr.lexpr.AsText + lcOperatorStr + lcQuery.Tables[0].DisplayName + "." + lcFunc.ArgAsTextByIndex(0);

                            lcExpr.IsParseAfterSetValue = false;
                            lcExpr.AsText = "not exists (" + lcNotExistsSubQueryStr + ")";
                            results.Add(format(stmt.AsText, stmt.DBVendor));

                            if (lcField.aliasclause == null)
                            {
                                lcNewAlias = lcFunc.FunctionName + "_" + lcFunc.ArgAsTextByIndex(0);
                            }

                            // build inline view
                            lcInlineViewStr = "select ";
                            lcGroupByStr = "";
                            // NodesToBeRewrited3 was filled in isJoinedColumnExpr12 of findJoinColumnConditionVisitor
                            for (int p = 0; p < NodesToBeRewrited3.Count; p++)
                            {
                                lcAttr = NodesToBeRewrited3[p] as TLz_Attr;
                                lcInlineViewStr = lcInlineViewStr + lcAttr.AsText;
                                lcGroupByStr = lcGroupByStr + lcAttr.AsText;
                                if (p != NodesToBeRewrited3.Count - 1)
                                {
                                    lcInlineViewStr = lcInlineViewStr + ",";
                                    lcGroupByStr = lcGroupByStr + ",";
                                }
                                if (lcAttr.ObjectNameToken != null)
                                {
                                    lcAttr.ObjectNameToken.AsText = gNewTableAlias;
                                }
                            }

                            lcInlineViewStr = lcInlineViewStr + "," + lcField.AsText;

                            if (lcField.aliasclause == null) //add column alias
                                lcInlineViewStr = lcInlineViewStr + " " + lcNewAlias;

                            lcInlineViewStr = lcInlineViewStr + " from " + lcQuery.FromClauseText;
                            //build wherestr will be in parent sql, remove where condition
                            lcWhereStr = "";
                            for (int n = 0; n < NodesToBeRewrited2.Count; n++)
                            {
                                lcExpr3 = NodesToBeRewrited2[n] as TLzCustomExpression;
                                lcWhereStr = lcWhereStr + lcExpr3.AsText;
                                if (n != NodesToBeRewrited2.Count - 1)
                                    lcWhereStr = lcWhereStr + " and ";

                                lcExpr3.IsParseAfterSetValue = false;
                                lcExpr3.AsText = " ";
                            }

                            if (lcQuery.WhereClauseText.Trim().Length > 0)
                                lcInlineViewStr = lcInlineViewStr + " where " + lcQuery.WhereClauseText;

                            lcInlineViewStr = lcInlineViewStr + " group by " + lcGroupByStr;

                            ((TSelectSqlStatement)gParentSql).FromClauseText =
                              ((TSelectSqlStatement)gParentSql).FromClauseText + ","
                              + "(" + lcInlineViewStr + ") " + gNewTableAlias;




                            // remove condition in co-related subquery
                            //                  for n = 0 to NodesToBeRewrited2.Count - 1 do
                            //                    {
                            //                      lcExpr3 =  NodesToBeRewrited2[n] as TLzCustomExpression;
                            //                      lcExpr3.AsText = " ";
                            //                    }

                            // modify co-related subquery to alias of aggregate function
                            if (lcField.aliasclause == null) //add column alias
                                lcExpr.rexpr.AsText = gNewTableAlias + "." + lcNewAlias;
                            else
                                lcExpr.rexpr.AsText = gNewTableAlias + "." + lcField.aliasclause.aliastext;

                            lcExpr.AsText = ""; // make sure astext is fetch from sub expression, not from astext directly.

                            gParentSql.WhereClauseText = gParentSql.WhereClauseText + " and " + lcWhereStr;

                            results.Add(format(stmt.AsText, stmt.DBVendor));

                            break;
                        }

                        break; // process one sql each time
                    }
                }
                // end
            } // while

        }
        private bool findEqualSubQueryVisitor(TLz_Node pnode,
Boolean pIsLeafNode)
        {
            if (pnode is TLzCustomExpression)
            {
                TLzCustomExpression lcExpr = pnode as TLzCustomExpression;
                switch (lcExpr.oper)
                {
                    case TLzOpType.Expr_subquery:

                        lcExpr.IsVisitSubTree = false; // don't check expr in subquery
                        break;

                    case TLzOpType.Expr_Comparison:

                        if (lcExpr.opname.AsText.Equals("="))
                        {
                            if (((TLzCustomExpression)lcExpr.rexpr).oper == TLzOpType.Expr_subquery)
                                NodesToBeRewrited.Add(lcExpr);
                            lcExpr.IsVisitSubTree = false; // don't check sub expr inside this expr
                        }
                        break;
                }
            }
            return true;
        }

        private void AddOracleHint(string pHint,
  TCustomSqlStatement pSql)
        {
            String lcHint = pSql.OracleHint;
            if (lcHint.Length > 0)
            {
                pSql.OracleHint = "/*+ " + getHint(lcHint.Trim()) + " " + pHint + "*/";
            }
            else
            {
                pSql.OracleHint = "/*+ " + pHint + " */";
            }
        }

        private string getHint(string ppHint)
        {
            return ppHint.Substring(4, ppHint.Length - 5);
        }

        private string PrepareHint(List<TLzTableHint> pTableHints)
        {
            String result = "";

            for (int i = 0; i < pTableHints.Count; i++)
            {
                if (pTableHints[i].tableName.Length > 0)
                {
                    result = result + pTableHints[i].hintName + "("
                        + pTableHints[i].tableName;
                    if (pTableHints[i].indexName.Length > 0)
                    {
                        result = result + " " + pTableHints[i].indexName;
                    }
                    result = result + ")";
                    if (i != pTableHints.Count - 1)
                        result = result + " ";
                }
                else if (pTableHints[i].hintName.Length > 0)
                {
                    if (result.Length > 0)
                        result = result + " ";
                    result = result + pTableHints[i].hintName;
                }
            }
            return result;
        }

        private void FindQueryIncludingTable(TCustomSqlStatement pSql)
        {
            string lcTableName;
            int lcold;
            List<TLzTableHint> lcTableHintArray = new List<TLzTableHint>();
            List<TLzTableHintSql> lcTableHintSqls = new List<TLzTableHintSql>();

            int n = 0;
            int s = 1;
            int m = 0;
            for (int i = 0; i < myTableHints.Count; i++)
            {
                lcTableName = myTableHints[i].tableName;
                if (lcTableName.Length == 0) continue;
                myTableHints[i].tables.Clear();

                for (int j = 0; j < pSql.Tables.Count(); j++)
                {
                    if (lcTableName.Equals(pSql.Tables[j].TableName, StringComparison.OrdinalIgnoreCase))
                        myTableHints[i].tables.Add(pSql.Tables[j]);
                }

                if (myTableHints[i].tables.Count() > 0)
                {
                    s = s * myTableHints[i].tables.Count();
                    n = n + myTableHints[i].tables.Count();
                }

            }

            if (n > 0)
            {
                for (int i = 0; i < myTableHints.Count; i++)
                {
                    lcTableName = myTableHints[i].tableName;
                    if (lcTableName.Length == 0) continue;
                    if (myTableHints[i].tables.Count() == 0) continue;
                    lcold = lcTableHintSqls.Count;

                    for (int j = 0; j < myTableHints[i].tables.Count(); j++)
                    {
                        if (lcTableHintSqls.Count == 0)
                        {
                            int count = myTableHints[i].tables.Count();
                            for (int p = 0; p < count; p++)
                            {
                                if (lcTableHintSqls.Count == p)
                                {
                                    lcTableHintSqls.Add(new TLzTableHintSql());
                                }
                                lcTableHintSqls[p].sql = pSql;
                                lcTableHintSqls[p].tableHintItems.Clear();
                                lcTableHintSqls[p].tableHintItems.Add(new TLzTableHint());

                                lcTableHintSqls[p].tableHintItems[0].tableName =
                                    myTableHints[i].tables[p].DisplayName;
                                lcTableHintSqls[p].tableHintItems[0].hintName =
                                    myTableHints[i].hintName;
                                lcTableHintSqls[p].tableHintItems[0].indexName =
                                    myTableHints[i].indexName;
                            }
                        }
                        else
                        {

                            for (int p = 0; p < lcold; p++)
                            {
                                if (j > 0)
                                {
                                    if (lcTableHintSqls.Count == j * lcold + p)
                                    {
                                        lcTableHintSqls.Add(new TLzTableHintSql());
                                    }
                                    lcTableHintSqls[j * lcold + p].sql = lcTableHintSqls[(j - 1) * lcold + p].sql;
                                    m = lcTableHintSqls[(j - 1) * lcold + p].tableHintItems.Count;
                                    for (int r = 0; r < m; r++)
                                    {
                                        if (lcTableHintSqls.Count == p)
                                        {
                                            lcTableHintSqls.Add(new TLzTableHintSql());
                                        }
                                        lcTableHintSqls[j * lcold + p].tableHintItems.Add(new TLzTableHint());
                                        lcTableHintSqls[j * lcold + p].tableHintItems[r].tableName =
                                          lcTableHintSqls[(j - 1) * lcold + p].tableHintItems[r].tableName;
                                        lcTableHintSqls[j * lcold + p].tableHintItems[r].hintName =
                                          lcTableHintSqls[(j - 1) * lcold + p].tableHintItems[r].hintName;
                                        lcTableHintSqls[j * lcold + p].tableHintItems[r].indexName =
                                          lcTableHintSqls[(j - 1) * lcold + p].tableHintItems[r].indexName;
                                    }
                                }

                                lcTableHintSqls[j * lcold + p].sql = pSql;
                                if (j == 0)
                                {
                                    lcTableHintSqls[j * lcold + p].tableHintItems.Add(new TLzTableHint());
                                }

                                m = lcTableHintSqls[j * lcold + p].tableHintItems.Count - 1;

                                lcTableHintSqls[j * lcold + p].tableHintItems[m].tableName =
                                  myTableHints[i].tables[j].DisplayName;
                                lcTableHintSqls[j * lcold + p].tableHintItems[m].hintName =
                                  myTableHints[i].hintName;
                                lcTableHintSqls[j * lcold + p].tableHintItems[m].indexName =
                                  myTableHints[i].indexName;
                            }

                        }
                    } // myTableHints.TableHintItems[i].Tables.Count
                } // myTableHints.Count
            } // n > 0

            //   lcTableHintSqls : TLzTableHintSqlArray;
            lcold = gTableHintSqls.Count;

            for (int i = 0; i < lcTableHintSqls.Count; i++)
            {
                gTableHintSqls.Add(lcTableHintSqls[i]);
            }


            //table_name : (NULL)
            //hint name  : ORDERED
            //index_name : (NULL)

            //-- Original SQL
            //SELECT COUNT(*)
            //  FROM TAB1, TAB2
            // WHERE TAB1.COL1 = TAB2.COL2 ;

            //-- Alter SQL
            //SELECT /*+ ORDERED */ COUNT(*)
            //  FROM TAB1, TAB2
            //   WHERE TAB1.COL1 = TAB2.COL2 ;

            if (pSql.OwnerStmt == null)
            { //top level sql only

                int k = 0;
                for (int i = 0; i < myTableHints.Count; i++)
                {
                    lcTableName = myTableHints[i].tableName;
                    if (lcTableName.Length == 0)
                    {
                        if (k == 0)
                        {
                            k++;
                            gTableHintSqls.Add(new TLzTableHintSql());
                            m = gTableHintSqls.Count - 1;
                            gTableHintSqls[m].sql = pSql;
                            gTableHintSqls[m].tableHintItems.Clear();
                            gTableHintSqls[m].tableHintItems.Add(new TLzTableHint());
                            gTableHintSqls[m].tableHintItems[0].tableName = "";
                            gTableHintSqls[m].tableHintItems[0].hintName =
                              myTableHints[i].hintName;
                            gTableHintSqls[m].tableHintItems[0].indexName = "";
                        }
                        else
                        {
                            m = gTableHintSqls.Count - 1;
                            gTableHintSqls[m].tableHintItems[0].hintName =
                              gTableHintSqls[m].tableHintItems[0].hintName
                              + " " + myTableHints[i].hintName;
                        }
                    }
                }

            }

            // check subquery of this sql

            for (int i = 0; i < pSql.ChildNodes.Count(); i++)
            {
                if (pSql.ChildNodes[i] is TSelectSqlStatement)
                    FindQueryIncludingTable(pSql.ChildNodes[i] as TSelectSqlStatement);
            }

        }

        private int GetTableHintTestFunction(List<TLzTableHint> pTableHintArray, string leadingTables, string hintNames, string indexNames)
        {
            if (leadingTables == null || leadingTables.Trim().Length == 0)
            {
                TLzTableHint tableHint = new TLzTableHint();
                tableHint.tableName = "";
                tableHint.hintName = hintNames.Trim();
                tableHint.indexName = "";
                pTableHintArray.Add(tableHint);
                return pTableHintArray.Count;
            }
            else
            {
                List<string> tableSplits = new List<string>(leadingTables.Trim().Split(','));
                List<string> hintSplits = new List<string>(hintNames.Trim().Split(','));
                List<string> indexNameSplits = new List<string>(indexNames.Trim().Split(','));
                removeEmptyString(tableSplits);
                removeEmptyString(hintSplits);
                removeEmptyString(indexNameSplits);
                int result = 0;
                for (int i = 0; i < tableSplits.Count; i++)
                {
                    TLzTableHint tableHint = new TLzTableHint();
                    tableHint.tableName = tableSplits[i].Trim();
                    if (hintSplits.Count == tableSplits.Count)
                    {
                        tableHint.hintName = hintSplits[i].Trim();
                        result = tableSplits.Count;
                    }
                    else tableHint.hintName = "";
                    if (indexNameSplits.Count == tableSplits.Count)
                    {
                        tableHint.indexName = indexNameSplits[i].Trim();
                        result = tableSplits.Count;
                    }
                    else tableHint.indexName = "";
                    pTableHintArray.Add(tableHint);
                }
                return result;
            }
        }

        private void removeEmptyString(List<string> list)
        {

            for (int i = 0; i < list.Count; i++)
            {
                String value = list[i];
                if (value == null || value.Trim().Length == 0)
                {
                    list.RemoveAt(i);
                    i--;
                }
            }
        }

        private bool findVisitor10(TLz_Node pnode,
  Boolean pIsLeafNode)
        {
            TLzCustomExpression lcExpr;
            Boolean result = true;

            if (pnode is TLzCustomExpression)
            {
                lcExpr = pnode as TLzCustomExpression;
                switch (lcExpr.oper)
                {
                    case TLzOpType.Expr_AND:
                    case TLzOpType.Expr_OR:
                    case TLzOpType.Expr_Parenthesis:
                        {
                            lcExpr.IsVisitSubTree = true;
                        }
                        break;
                    case TLzOpType.Expr_subquery:
                        {
                            lcExpr.IsVisitSubTree = false;
                        }
                        break;
                    case TLzOpType.Expr_In:
                    case TLzOpType.Expr_NotIn:
                    case TLzOpType.Expr_Comparison:
                        {
                            lcExpr.IsVisitSubTree = false;
                            if (isJoinedColumnExpr(lcExpr, gCurrentSql.Tables))
                                NodesToBeRewrited2.Add(lcExpr);
                        }
                        break;
                }
            }
            return result;
        }

        private Boolean isJoinedColumnExpr(TLzCustomExpression pExpr,
  TLzTableList pTables)
        {

            TLzCustomExpression lcExpr, lcExpr1, lcExpr2;
            TLz_Attr lcAttr;
            Boolean result = false;
            lcExpr1 = pExpr.lexpr as TLzCustomExpression;
            lcExpr2 = pExpr.rexpr as TLzCustomExpression;
            if (lcExpr1.oper == TLzOpType.Expr_Const || lcExpr2.oper == TLzOpType.Expr_Const) return result;

            gAttrExprList.Clear();
            lcExpr1.PreOrderTraverse(findAttrExprVisitor);
            if (gAttrExprList.Count() == 0) return result;
            for (int i = 0; i < gAttrExprList.Count(); i++)
            {
                lcExpr = gAttrExprList[i] as TLzCustomExpression;
                lcAttr = lcExpr.lexpr as TLz_Attr;
                result = DoisColumnInTableList(lcAttr, pTables);
                if (result) break;

            }

            if (!result) return result;

            if (pExpr.oper == TLzOpType.Expr_In && ((TLzCustomExpression)pExpr.rexpr).oper == TLzOpType.Expr_subquery) return result;

            result = false;

            gAttrExprList.Clear();
            lcExpr2.PreOrderTraverse(findAttrExprVisitor);
            if (gAttrExprList.Count() == 0) return result;
            for (int i = 0; i < gAttrExprList.Count(); i++)
            {
                lcExpr = gAttrExprList[i] as TLzCustomExpression;
                lcAttr = lcExpr.lexpr as TLz_Attr;
                result = DoisColumnInTableList(lcAttr, pTables);
                if (result) break;
            }

            return result;
        }

        private Boolean DoisColumnInTableList(TLz_Attr lcAttr, TLzTableList pTables)
        {
            Boolean result = false;
            if (lcAttr.ObjectNameToken != null)
            {
                if (isColumnInTableList(lcAttr.ObjectNameToken.AsText, lcAttr.ColumnNameToken.AsText, pTables))
                {
                    result = true;
                }
            }
            else if (lcAttr.ColumnNameToken != null && lcAttr.ObjectPropertyNameToken != null)
            {
                result = false;
            }
            else
            {
                if (lcAttr.ColumnNameToken != null)
                {
                    if (isColumnInTableList("", lcAttr.ColumnNameToken.AsText, pTables))
                    {
                        result = true;
                    }
                }
            }
            return result;
        }

        private bool findJoinColumnConditionVisitor(TLz_Node pnode,
          Boolean pIsLeafNode)
        {
            TLzCustomExpression lcExpr;
            Boolean result = true;

            if (pnode is TLzCustomExpression)
            {
                lcExpr = pnode as TLzCustomExpression;
                switch (lcExpr.oper)
                {
                    case TLzOpType.Expr_AND:
                    case TLzOpType.Expr_OR:
                    case TLzOpType.Expr_Parenthesis:
                        {
                            lcExpr.IsVisitSubTree = true;
                        }
                        break;
                    case TLzOpType.Expr_subquery:
                        {
                            lcExpr.IsVisitSubTree = false;
                        }
                        break;
                    case TLzOpType.Expr_In:
                    case TLzOpType.Expr_NotIn:
                    case TLzOpType.Expr_Comparison:
                        {
                            lcExpr.IsVisitSubTree = false;
                            if (isJoinedColumnExpr12(lcExpr, gCurrentSql.Tables, gParentSql.Tables))
                                NodesToBeRewrited2.Add(lcExpr);
                        }
                        break;
                }
            }
            return result;
        }

        private Boolean isJoinedColumnExpr12(TLzCustomExpression pExpr,
  TLzTableList pTables, TLzTableList pParentTables)
        {

            TLzCustomExpression lcExpr, lcExpr1, lcExpr2;
            TLz_Attr lcAttr;
            Boolean isParentExpr, isSelfExpr;
            Boolean result = false;

            lcExpr1 = pExpr.lexpr as TLzCustomExpression;
            lcExpr2 = pExpr.rexpr as TLzCustomExpression;
            if (lcExpr1.oper == TLzOpType.Expr_Const || lcExpr2.oper == TLzOpType.Expr_Const) return result;

            isParentExpr = false;
            isSelfExpr = false;

            gAttrExprList.Clear();
            lcExpr1.PreOrderTraverse(findAttrExprVisitor);
            if (gAttrExprList.Count() == 0) return result;
            for (int i = 0; i < gAttrExprList.Count(); i++)
            {
                lcExpr = gAttrExprList[i] as TLzCustomExpression;
                lcAttr = lcExpr.lexpr as TLz_Attr;

                if (!isParentExpr)
                    isParentExpr = DoisColumnInTableList(lcAttr, pParentTables, false);

                if (!isSelfExpr)
                    isSelfExpr = DoisColumnInTableList(lcAttr, pTables, true);

                if (isParentExpr && isSelfExpr) break;

            }

            gAttrExprList.Clear();
            lcExpr2.PreOrderTraverse(findAttrExprVisitor);
            if (gAttrExprList.Count() == 0) return result;
            for (int i = 0; i < gAttrExprList.Count(); i++)
            {
                lcExpr = gAttrExprList[i] as TLzCustomExpression;
                lcAttr = lcExpr.lexpr as TLz_Attr;

                if (!isParentExpr)
                    isParentExpr = DoisColumnInTableList(lcAttr, pParentTables, false);

                if (!isSelfExpr)
                    isSelfExpr = DoisColumnInTableList(lcAttr, pTables, true);

                if (isParentExpr && isSelfExpr) break;
            }

            result = isParentExpr && isSelfExpr;
            return result;
        }

        private Boolean DoisColumnInTableList(TLz_Attr lcAttr, TLzTableList ppTables, Boolean pIsSelf)
        {
            Boolean result = false;
            if (lcAttr.ObjectNameToken != null)
            {
                if (isColumnInTableList(lcAttr.ObjectNameToken.AsText, lcAttr.ColumnNameToken.AsText, ppTables))
                {
                    result = true;
                    if (pIsSelf)
                    {
                        NodesToBeRewrited3.Add(lcAttr);
                        // lcAttr.ObjectNameToken.AsText = gNewTableAlias;
                    }
                }
            }
            else if (lcAttr.ColumnNameToken != null && lcAttr.ObjectPropertyNameToken != null)
            {
                result = false;
            }
            else
            {
                //         if isColumnInTableList('',lcAttr.ColumnNameToken.AsText,ppTables){
                //           {
                //             result = true;
                //           }
            }
            return result;
        }

        private Boolean isColumnInTableList(String pColumnPrefix, String pColumnText,
TLzTableList pTableList)
        {
            return TableListIncludeThisColumn(pColumnPrefix, pColumnText, pTableList) != null;
        }


        private int ModifyJoinedColumnInFields(TLzFieldList pFields,
          String pLeadingTableName, String leadingTable)
        {

            TLzField lcField;
            TLz_Attr lcAttr;
            TLzCustomExpression lcExpr;

            int result = 0;
            for (int i = 0; i < pFields.Count(); i++)
            {
                lcField = pFields[i];
                if (lcField.FieldType == TLzFieldType.lftAttr)
                {
                    lcAttr = lcField.FieldAttr;
                    result = doModifyJoinColumnInFields(lcAttr, pLeadingTableName, leadingTable, result);
                }
                else if (lcField.FieldType == TLzFieldType.lftExpression)
                {
                    lcExpr = lcField.FieldExpr;
                    gAttrExprList.Clear();
                    lcExpr.PreOrderTraverse(findAttrExprVisitor);
                    for (int j = 0; j < gAttrExprList.Count(); j++)
                    {
                        lcAttr = ((TLzCustomExpression)gAttrExprList[j]).lexpr as TLz_Attr;
                        result = doModifyJoinColumnInFields(lcAttr, pLeadingTableName, leadingTable, result);
                    }
                }

            }
            return result;
        }

        private int doModifyJoinColumnInFields(TLz_Attr lcAttr, String pLeadingTableName, String leadingTable, int result)
        {

            String lcOwner;

            if (lcAttr.ObjectNameToken != null)
            {
                if (pLeadingTableName.Equals(lcAttr.ObjectNameToken.AsText, StringComparison.OrdinalIgnoreCase))
                {
                    NodesToBeRewrited3.Add(lcAttr);
                    lcAttr.OrigText = lcAttr.AsText;
                    lcOwner = "";
                    if (lcAttr.SchemaNameToken != null)
                        lcOwner = lcAttr.SchemaNameToken.AsText;
                    if (fGetDatatypeFunction(lcOwner, leadingTable, lcAttr.ColumnNameToken.AsText) == 1)
                        lcAttr.AsText = lcAttr.AsText + "+ 0";
                    else if (fGetDatatypeFunction(lcOwner, leadingTable, lcAttr.ColumnNameToken.AsText) == 2)
                        lcAttr.AsText = lcAttr.AsText + "||NULL";
                    result++;
                }
            }
            else
            {
                if (sketch_f_get_alias("", "", leadingTable, lcAttr.ColumnNameToken.AsText))
                {
                    NodesToBeRewrited3.Add(lcAttr);
                    lcAttr.OrigText = lcAttr.AsText;
                    if (fGetDatatypeFunction("", leadingTable, lcAttr.ColumnNameToken.AsText) == 1)
                        lcAttr.AsText = lcAttr.AsText + "+ 0";
                    else if (fGetDatatypeFunction("", leadingTable, lcAttr.ColumnNameToken.AsText) == 2)
                        lcAttr.AsText = lcAttr.AsText + "||NULL";
                    result++;
                }
            }
            return result;
        }

        private int ModifyJoinedColumnExprWithLeadingTable(
  TLzCustomExpression pExpr, String pTableName, String leadingTable)
        {

            TLzCustomExpression lcExpr, lcExpr1, lcExpr2;
            TLz_Attr lcAttr;

            int result = 0;
            lcExpr1 = pExpr.lexpr as TLzCustomExpression;
            lcExpr2 = pExpr.rexpr as TLzCustomExpression;

            gAttrExprList.Clear();
            lcExpr1.PreOrderTraverse(findAttrExprVisitor);

            for (int i = 0; i < gAttrExprList.Count(); i++)
            {
                lcExpr = gAttrExprList[i] as TLzCustomExpression;
                lcAttr = lcExpr.lexpr as TLz_Attr;
                result = doModifyJoinColumn(lcAttr, pTableName, leadingTable, lcExpr, result);
            }


            if (pExpr.oper == TLzOpType.Expr_In && ((TLzCustomExpression)pExpr.rexpr).oper == TLzOpType.Expr_subquery) return result;


            gAttrExprList.Clear();
            lcExpr2.PreOrderTraverse(findAttrExprVisitor);

            for (int i = 0; i < gAttrExprList.Count(); i++)
            {
                lcExpr = gAttrExprList[i] as TLzCustomExpression;
                lcAttr = lcExpr.lexpr as TLz_Attr;
                result = doModifyJoinColumn(lcAttr, pTableName, leadingTable, lcExpr, result);

            }
            return result;
        }

        private int doModifyJoinColumn(TLz_Attr lcAttr, String pTableName, String leadingTable, TLzCustomExpression lcExpr, int result)
        {
            string lcOwner;
            if (lcAttr.ObjectNameToken != null)
            {
                if (pTableName.Equals(lcAttr.ObjectNameToken.AsText, StringComparison.OrdinalIgnoreCase))
                {
                    NodesToBeRewrited3.Add(lcExpr);
                    lcExpr.IsParseAfterSetValue = false;
                    lcExpr.OrigText = lcExpr.AsText;
                    lcOwner = "";
                    if (lcAttr.SchemaNameToken != null)
                        lcOwner = lcAttr.SchemaNameToken.AsText;
                    if (fGetDatatypeFunction(lcOwner, leadingTable, lcAttr.ColumnNameToken.AsText) == 1)
                        lcExpr.AsText = lcExpr.AsText + "+ 0";
                    else if (fGetDatatypeFunction(lcOwner, leadingTable, lcAttr.ColumnNameToken.AsText) == 2)
                        lcExpr.AsText = "trim(" + lcExpr.AsText + ")";
                    result++;
                }
            }
            else
            {
                if (sketch_f_get_alias("", "", leadingTable, lcAttr.ColumnNameToken.AsText))
                {
                    NodesToBeRewrited3.Add(lcExpr);
                    lcExpr.OrigText = lcExpr.AsText;
                    if (fGetDatatypeFunction("", leadingTable, lcAttr.ColumnNameToken.AsText) == 1)
                        lcExpr.AsText = lcExpr.AsText + "+ 0";
                    else if (fGetDatatypeFunction("", leadingTable, lcAttr.ColumnNameToken.AsText) == 2)
                        lcExpr.AsText = "trim(" + lcExpr.AsText + ")";
                    result++;
                }
            }
            return result;
        }

        private int fGetDatatypeFunction(String p_owner, String p_table_name, String p_column_name)
        {
            return 1;
        }

        public static Boolean sketch_f_get_alias(String p_alias, String p_owner, String p_table_name, String p_column_name)
        {
            if (p_alias.Length == 0)
            {
                return true;
                // check database info here
            }
            else
            {
                return p_alias.Equals(p_table_name, StringComparison.OrdinalIgnoreCase);
            }
        }

        private void FindQueryIncludingLeadingTable(string pTableName,
  TCustomSqlStatement pSql)
        {

            for (int i = 0; i < pSql.Tables.Count(); i++)
            {
                if (pTableName.Equals(pSql.Tables[i].TableName, StringComparison.OrdinalIgnoreCase))
                {
                    NodesToBeRewrited.Add(pSql);
                    break;
                }
            }
            // check subquery of this sql

            for (int i = 0; i < pSql.ChildNodes.Count(); i++)
            {
                if (pSql.ChildNodes[i] is TSelectSqlStatement)
                    if (((TSelectSqlStatement)pSql.ChildNodes[i]).Location != TLzOwnerLocation.elfield) // make sure it's not scalar subquery
                        FindQueryIncludingLeadingTable(pTableName, pSql.ChildNodes[i] as TSelectSqlStatement);
            }
        }

        private Boolean doRewriteSqlByRule9(TCustomSqlStatement pSelect,
 TLzCustomExpression pExpr)
        {
            TSelectSqlStatement lcSubQuery;
            TLzCustomExpression lcLExpr, lcRExpr, lcPPExpr;
            TLz_Attr lcLAttr, lcRAttr;
            int listCount;
            String lcInStr, lcFieldStr, lcWhereStr1;
            Boolean isNotExists;

            Boolean result = false;
            if (pExpr.oper != TLzOpType.Expr_Exists) return result;
            lcSubQuery = pExpr.rexpr as TSelectSqlStatement;
            if (lcSubQuery.WhereClause == null) return result;
            NodesToBeRewrited2.Clear();
            lcSubQuery.WhereClause.PreOrderTraverse(findEqualExprVisitor);
            if (NodesToBeRewrited2.Count == 0) return result;

            listCount = 0;
            lcInStr = "";
            lcFieldStr = "";
            lcWhereStr1 = "";

            for (int i = 0; i < NodesToBeRewrited2.Count; i++)
            {
                lcLExpr = ((TLzCustomExpression)NodesToBeRewrited2[i]).lexpr as TLzCustomExpression;
                lcRExpr = ((TLzCustomExpression)NodesToBeRewrited2[i]).rexpr as TLzCustomExpression;
                if (!((lcLExpr != null) && (lcRExpr != null))) continue;
                if (!((lcLExpr.oper == TLzOpType.Expr_Attr) && (lcRExpr.oper == TLzOpType.Expr_Attr))) continue;
                lcLAttr = lcLExpr.lexpr as TLz_Attr;
                lcRAttr = lcRExpr.lexpr as TLz_Attr;

                if (!((lcLAttr.ObjectNameToken != null) && (lcRAttr.ObjectNameToken != null))) continue;


                if (FindTableNameOrAlias(lcLAttr.ObjectNameToken.AsText, pSelect.Tables) != 0
                && FindTableNameOrAlias(lcRAttr.ObjectNameToken.AsText, lcSubQuery.Tables) != 0)
                {
                    if (listCount > 0)
                    {
                        lcInStr = lcInStr + ",";
                        lcWhereStr1 = lcWhereStr1 + " and ";
                    }
                    lcInStr = lcInStr + lcLAttr.AsText;
                    lcWhereStr1 = lcWhereStr1 + lcLAttr.AsText + " is not null";


                    if (listCount > 0)
                    {
                        lcFieldStr = lcFieldStr + ",";
                    }

                    lcFieldStr = lcFieldStr + lcRAttr.AsText;

                    listCount++;
                    //remove this condition from where clause
                    ((TLzCustomExpression)NodesToBeRewrited2[i]).AsText = lcRAttr.AsText + " is not null";
                }
                else if (FindTableNameOrAlias(lcRAttr.ObjectNameToken.AsText, pSelect.Tables) != 0
                 && FindTableNameOrAlias(lcLAttr.ObjectNameToken.AsText, lcSubQuery.Tables) != 0)
                {
                    if (listCount > 0)
                    {
                        lcInStr = lcInStr + ",";
                        lcWhereStr1 = lcWhereStr1 + " and ";
                    }

                    lcInStr = lcInStr + lcRAttr.AsText;
                    lcWhereStr1 = lcWhereStr1 + lcRAttr.AsText + " is not null";

                    if (listCount > 0)
                    {
                        lcFieldStr = lcFieldStr + ",";
                    }

                    lcFieldStr = lcFieldStr + lcLAttr.AsText;

                    listCount++;
                    //remove this condition from where clause
                    ((TLzCustomExpression)NodesToBeRewrited2[i]).AsText = lcLAttr.AsText + " is not null";
                }
            }


            if (listCount > 0)
            {
                if (listCount > 1)
                    lcInStr = "(" + lcInStr + ")";
                lcSubQuery.OracleHint = "/*+ HASH_AJ */";
                lcSubQuery.SelectClauseText = lcFieldStr;

                // check is this "not exists"
                isNotExists = false;
                if (pExpr.parentNode != null)
                {
                    lcPPExpr = pExpr.parentNode as TLzCustomExpression;
                    if (lcPPExpr.oper == TLzOpType.Expr_NOT)
                    {
                        lcPPExpr.IsParseAfterSetValue = false;
                        lcPPExpr.AsText = lcWhereStr1 + " and " + lcInStr + " not in " + lcSubQuery.AsText;
                        isNotExists = true;
                    }
                }

                if (!isNotExists)
                {
                    pExpr.IsParseAfterSetValue = false;
                    pExpr.AsText = lcWhereStr1 + " and " + lcInStr + " in " + lcSubQuery.AsText;
                }

                result = true;
            }
            return result;
        }

        private Boolean CheckObjectIsViewTestFunction(String p_owner, String p_objectname, out string pViewText)
        {

            if ("xxopsm_delivery_pack_v".Equals(p_objectname, StringComparison.OrdinalIgnoreCase))
            {
                pViewText = ""
                + "\t" + "("
                + "\t" + " SELECT xdh.organization_id            AS organization_id, "
                + "\t" + "        xdpp.plan_batch_id             AS plan_batch_id, "
                + "\t" + "        'PALLET'                     AS packing_div, "
                + "\t" + "        xdpp.pallet_id                 AS pallet_id, "
                + "\t" + "        NULL                           AS box_id, "
                + "\t" + "        1                              AS packing_qty, "
                + "\t" + "        xdpp.packing_pallet_net_weight AS packing_nw, "
                + "\t" + "        xdpp.total_weight              AS packing_gw, "
                + "\t" + "        xdpp.pallet_qty                AS pallet_qty, "
                + "\t" + "        xdpp.attribute1                AS part_no, "
                + "\t" + "        xdpp.attribute2                AS part_cnt "
                + "\t" + " FROM   xxopsm_delivery_headers xdh, "
                + "\t" + "        xxopsm_dv_plt_packings xdpp "
                + "\t" + " WHERE  xdh.plan_batch_id = xdpp.plan_batch_id "
                + "\t" + " UNION  "
                + "\t" + " SELECT xdh.organization_id        AS organization_id, "
                + "\t" + "        xdb.plan_batch_id          AS plan_batch_id, "
                + "\t" + "        'BOX'                    AS packing_div, "
                + "\t" + "        NULL                       AS pallet_id, "
                + "\t" + "        xdb.to_box_no              AS box_id, "
                + "\t" + "        1                          AS packing_qty, "
                + "\t" + "        xdb.packing_box_net_weight AS packing_nw, "
                + "\t" + "        xdb.total_weight           AS packing_gw, "
                + "\t" + "        xdb.box_packing_qty        AS pallet_qty, "
                + "\t" + "        xdb.attribute1             AS part_no, "
                + "\t" + "        xdb.attribute2             AS part_cnt "
                + "\t" + " FROM   xxopsm_delivery_headers xdh, "
                + "\t" + "        xxopsm_delivery_boxes xdb "
                + "\t" + " WHERE  xdh.plan_batch_id = xdb.plan_batch_id "
                + "\t" + "        AND NOT EXISTS (SELECT 'x' "
                + "\t" + "                        FROM   xxopsm_delivery_headers xdh, "
                + "\t" + "                               xxopsm_dv_plt_packings xdpp "
                + "\t" + "                        WHERE  xdh.plan_batch_id = xdpp.plan_batch_id "
                + "\t" + "                               AND xdpp.plan_batch_id = xdb.plan_batch_id))";
            }
            else
                pViewText = "(select f1,f2 from t1)";
            return true;
        }

        private Boolean doRewriteSqlByRule7(TSelectSqlStatement pSelect,
 TLzCustomExpression pExpr)
        {

            TLzCustomExpression lcExpr, lclExpr, lcrExpr, lcFuncExpr;
            TLz_FuncCall lcFunc;

            Boolean result = true;


            lcExpr = pExpr;//NodesToBeRewrited[0] as  TLzCustomExpression;
            lclExpr = lcExpr.lexpr as TLzCustomExpression;
            lcrExpr = lcExpr.rexpr as TLzCustomExpression;
            if (lclExpr.oper == TLzOpType.Expr_FuncCall)
                lcFuncExpr = lclExpr;
            else
            {
                lcFuncExpr = lcrExpr;
                lcrExpr = lclExpr;
            }

            lcFunc = lcFuncExpr.lexpr as TLz_FuncCall;

            // generate new where condition
            if ("to_char".Equals(lcFunc.FunctionName, StringComparison.OrdinalIgnoreCase))
            {
                if ("'yyyymm'".Equals(lcFunc.ArgAsTextByIndex(1), StringComparison.OrdinalIgnoreCase))
                {
                    if (lcExpr.oper == TLzOpType.Expr_Comparison)
                    {
                        lcExpr.AsText = lcFunc.ArgAsTextByIndex(0) + ">= to_date(" + lcrExpr.AsText + "," + lcFunc.ArgAsTextByIndex(1) + ")" +
                        " and " + lcFunc.ArgAsTextByIndex(0) + "< last_day(to_date(" + lcrExpr.AsText + "," + lcFunc.ArgAsTextByIndex(1) + "))+1";
                    }
                    else if (lcExpr.oper == TLzOpType.Expr_Between)
                    {
                        lcExpr.AsText = lcFunc.ArgAsTextByIndex(0) + ">= to_date(" + lcrExpr.lexpr.AsText + "," + lcFunc.ArgAsTextByIndex(1) + ")" +
                        " and " + lcFunc.ArgAsTextByIndex(0) + "< last_day(to_date(" + lcrExpr.rexpr.AsText + "," + lcFunc.ArgAsTextByIndex(1) + "))+1";
                    }
                    pSelect.RawSqlText = pSelect.AsText;
                    result = true;
                }
                //       if (mycomparetext("""yyyymmdd""",lcFunc.ArgAsTextByIndex(1))=0)
                //       or (mycomparetext("""dd-mon-yyyy""",lcFunc.ArgAsTextByIndex(1))=0)
                else
                {
                    if (lcExpr.oper == TLzOpType.Expr_Comparison)
                    {
                        if (lcExpr.opname.AsText.Equals("="))
                        {
                            lcExpr.AsText = lcFunc.ArgAsTextByIndex(0) + ">= to_date(" + lcrExpr.AsText + "," + lcFunc.ArgAsTextByIndex(1) + ")" +
                            " and " + lcFunc.ArgAsTextByIndex(0) + "< to_date(" + lcrExpr.AsText + "," + lcFunc.ArgAsTextByIndex(1) + ")+1";
                        }
                        else
                        {
                            lcExpr.AsText = lcFunc.ArgAsTextByIndex(0) + lcExpr.opname.AsText + " to_date(" + lcrExpr.AsText + "," + lcFunc.ArgAsTextByIndex(1) + ")";
                        }
                    }
                    else if (lcExpr.oper == TLzOpType.Expr_Between)
                    {
                        lcExpr.AsText = lcFunc.ArgAsTextByIndex(0) + ">= to_date(" + lcrExpr.lexpr.AsText + "," + lcFunc.ArgAsTextByIndex(1) + ")" +
                        " and " + lcFunc.ArgAsTextByIndex(0) + "< to_date(" + lcrExpr.rexpr.AsText + "," + lcFunc.ArgAsTextByIndex(1) + ")";
                    }

                    pSelect.RawSqlText = pSelect.AsText;
                    result = true;
                }
            }
            else if ("to_date".Equals(lcFunc.FunctionName, StringComparison.OrdinalIgnoreCase))
            {

                if (lcExpr.oper == TLzOpType.Expr_Comparison)
                {
                    lcExpr.AsText = lcFunc.ArgAsTextByIndex(0) + lcExpr.opname.AsText + " to_char(" + lcrExpr.AsText + "," + lcFunc.ArgAsTextByIndex(1) + ")";
                }
                //       else if lcExpr.oper = Expr_Between
                //         {
                //           lcExpr.AsText =  lcFunc.ArgAsTextByIndex(0)+">= to_date("+lcrExpr.lexpr.AsText+","+lcFunc.ArgAsTextByIndex(1)+")"+
                //           " and "+lcFunc.ArgAsTextByIndex(0)+"< to_date("+lcrExpr.rexpr.AsText+","+lcFunc.ArgAsTextByIndex(1)+")";
                //         }

                pSelect.RawSqlText = pSelect.AsText;
                result = true;
            }
            else if ("substr".Equals(lcFunc.FunctionName, StringComparison.OrdinalIgnoreCase))
            {
                lcExpr.AsText = lcFunc.ArgAsTextByIndex(0) + " like " + lcrExpr.AsText + " || '%'";
                pSelect.RawSqlText = pSelect.AsText;
                result = true;
            }
            return result;
        }
        private Boolean findAttrExprVisitor(TLz_Node pnode, Boolean pIsLeafNode)
        {
            //  isExcluded : Boolean;
            TLzCustomExpression lcExpr;
            //  subquery : TSelectSqlStatement;
            TLz_FuncCall lcFunc;
            TLz_Attr lcAttr;

            if (pnode is TLzCustomExpression)
            {
                lcExpr = pnode as TLzCustomExpression;
                if (lcExpr.oper == TLzOpType.Expr_Attr)
                {
                    lcAttr = lcExpr.lexpr as TLz_Attr;
                    if (lcAttr.LastToken.TokenType != TTokenType.ttBindVar)
                        gAttrExprList.Add(lcExpr);
                }
                else if (lcExpr.oper == TLzOpType.Expr_FuncCall)
                {
                    lcFunc = lcExpr.lexpr as TLz_FuncCall;
                    if (lcFunc.args != null)
                    {
                        for (int i = 0; i < lcFunc.args.Count(); i++)
                        {
                            if (lcFunc.args[i] is TLzCustomExpression)
                            {
                                ((TLzCustomExpression)lcFunc.args[i]).PreOrderTraverse(findAttrExprVisitor);
                            }
                        }
                    }
                }
                lcExpr.IsVisitSubTree = true;
            }
            return true;
        }

        private Boolean findNotExistsSubQueryVisitor(TLz_Node pnode, Boolean pIsLeafNode)
        {
            Boolean isExcluded;
            TLzCustomExpression lcExpr, lcParentExpr, lcPParentExpr;
            TSelectSqlStatement subquery;
            if (pnode is TLzCustomExpression)
            {
                lcExpr = pnode as TLzCustomExpression;
                switch (lcExpr.oper)
                {
                    case TLzOpType.Expr_subquery:
                        {
                            lcExpr.IsVisitSubTree = false; // don't check expr in subquery
                        }
                        break;
                    case TLzOpType.Expr_Exists:
                        {
                            // exclude 'or'
                            isExcluded = true;
                            lcParentExpr = null;
                            if (lcExpr.parentNode != null)
                            {
                                lcParentExpr = lcExpr.parentNode as TLzCustomExpression;
                                if (lcParentExpr.oper == TLzOpType.Expr_OR)
                                {
                                    isExcluded = true;
                                }
                                else if (lcParentExpr.oper == TLzOpType.Expr_NOT) //not exists
                                {
                                    isExcluded = false;
                                    // exclude if 'or' condition before not exists
                                    if (lcParentExpr.parentNode != null)
                                    {
                                        lcPParentExpr = lcParentExpr.parentNode as TLzCustomExpression;
                                        if (lcPParentExpr.oper == TLzOpType.Expr_OR)
                                        {
                                            isExcluded = true;
                                        }
                                    }
                                }
                            }

                            // exclude subquery has 'unial all','minus','intersect'
                            if (!isExcluded)
                            {
                                subquery = lcExpr.rexpr as TSelectSqlStatement;
                                if (subquery.SelectSetType == TSelectSetType.sltUnion || subquery.SelectSetType == TSelectSetType.sltUnionAll || subquery.SelectSetType == TSelectSetType.sltMinus || subquery.SelectSetType == TSelectSetType.sltIntersect || subquery.SelectSetType == TSelectSetType.sltIntersectAll)
                                    isExcluded = true;
                            }

                            if (!isExcluded)
                            {
                                if (lcParentExpr != null)
                                    if (lcParentExpr.oper == TLzOpType.Expr_NOT)
                                        inquerys.Add(lcParentExpr);

                                NodesToBeRewrited.Add(lcExpr);
                            }

                            lcExpr.IsVisitSubTree = false; // don't check sub expr inside this expr
                        }
                        break;
                }
            }
            return true;
        }

        private Boolean findVisitor7(TLz_Node pnode, Boolean pIsLeafNode)
        {
            TLzCustomExpression lcExpr, lcExpr1, lcExpr2, lcParentExpr;
            //  lcList : Tlz_list;
            TLz_FuncCall lcFunc;
            Boolean isValidExpr;
            Boolean result = true;

            if (pnode is TLzCustomExpression)
            {
                lcExpr = pnode as TLzCustomExpression;
                // make sure lcexpr is in expr "=" or between
                isValidExpr = false;
                if (lcExpr.parentNode != null)
                {
                    lcParentExpr = lcExpr.parentNode as TLzCustomExpression;
                    if (lcParentExpr.oper == TLzOpType.Expr_Between) isValidExpr = true;
                    if (lcParentExpr.oper == TLzOpType.Expr_Comparison)
                    {
                        isValidExpr = true;
                    }
                }


                if (isValidExpr && (lcExpr.oper == TLzOpType.Expr_FuncCall))
                {
                    lcExpr.IsVisitSubTree = false;
                    lcFunc = lcExpr.lexpr as TLz_FuncCall;
                    if ("to_char".Equals(lcFunc.FunctionName, StringComparison.OrdinalIgnoreCase)
                      || "to_date".Equals(lcFunc.FunctionName, StringComparison.OrdinalIgnoreCase))
                    {
                        if (lcFunc.args.Count() != 2) return result;
                        if (!(lcFunc.args[0] is TLzCustomExpression)) return result;
                        if (!(lcFunc.args[1] is TLzCustomExpression)) return result;
                        lcExpr1 = lcFunc.args[0] as TLzCustomExpression;
                        // lcExpr2 = lcFunc.args[1] as TLzCustomExpression;
                        if (isColumnInExpr7(lcExpr1))
                        {
                            if (lcExpr.parentNode != null)
                            {
                                NodesToBeRewrited.Add(lcExpr.parentNode);
                                result = true;//false;
                            }
                        }
                    }
                    else if ("substr".Equals(lcFunc.FunctionName, StringComparison.OrdinalIgnoreCase))
                    {
                        // param of nvl function must be column of table
                        if (lcFunc.args.Count() != 3) return result;
                        if (!(lcFunc.args[0] is TLzCustomExpression)) return result;
                        if (!(lcFunc.args[1] is TLzCustomExpression)) return result;
                        lcExpr1 = lcFunc.args[0] as TLzCustomExpression;
                        lcExpr2 = lcFunc.args[1] as TLzCustomExpression;
                        if (isColumnInExpr7(lcExpr1) && ("1".Equals(lcExpr2.AsText, StringComparison.OrdinalIgnoreCase)))
                        {
                            if (lcExpr.parentNode != null)
                            {
                                NodesToBeRewrited.Add(lcExpr.parentNode);
                                result = true;//false;
                            }
                        }
                    }
                }
            }
            return result;
        }

        private Boolean isColumnInExpr7(TLzCustomExpression ppExpr)
        {
            TSourceToken lcToken, lcStartToken, lcEndToken;
            TSourceTokenList lcTokenList;
            Boolean result = false;

            lcStartToken = ppExpr.StartToken;
            lcEndToken = ppExpr.EndToken;
            lcTokenList = lcStartToken.Container;
            if (!((lcStartToken != null) && (lcEndToken != null))) return result;
            if (lcTokenList == null) return result;

            for (int j = lcStartToken.posinlist; j <= lcEndToken.posinlist; j++)
            {
                lcToken = lcTokenList[j];
                result = lcToken.DBObjType == TDBObjType.ttObjField;
                if (result) break;
            }
            return result;
        }

        private Boolean doRewriteSqlByRule6(TSelectSqlStatement pSelect,
 TLzCustomExpression pExpr)
        {

            TLzCustomExpression lcExpr, lclExpr, lcrExpr, lcFuncExpr;
            String lcOrderByStr, lcStr, lcStr2;
            List<string> lcStrList = new List<string>();
            TLz_FuncCall lcFunc;
            Boolean lcIsColumnNotNull;
            TLz_Attr lcAttr;
            String lcSchemaStr, lcObjectStr;
            Boolean result = false;

            lcOrderByStr = "";
            if (pSelect.SortClauseText.Length > 0)
            {
                lcOrderByStr = pSelect.SortClauseText;
                pSelect.SortClauseText = " ";
            }

            lcExpr = pExpr;//NodesToBeRewrited[0] as  TLzCustomExpression;
            lclExpr = lcExpr.lexpr as TLzCustomExpression;
            lcrExpr = lcExpr.rexpr as TLzCustomExpression;

            // find
            if (lclExpr.oper == TLzOpType.Expr_FuncCall && lclExpr.DummyTag == 3)
                lcFuncExpr = lclExpr;
            else
                lcFuncExpr = lcrExpr;

            lcFunc = lcFuncExpr.lexpr as TLz_FuncCall;

            lcIsColumnNotNull = false;

            // check is first column in nvl is not null
            if (lcFunc.args[0] is TLzCustomExpression)
            {
                if (((TLzCustomExpression)lcFunc.args[0]).oper == TLzOpType.Expr_Attr)
                {
                    lcAttr = ((TLzCustomExpression)lcFunc.args[0]).lexpr as TLz_Attr;
                    if (lcAttr.ColumnNameToken != null)
                    {
                        lcSchemaStr = "";
                        lcObjectStr = "";
                        if (lcAttr.SchemaNameToken != null)
                            lcSchemaStr = lcAttr.SchemaNameToken.AsText;
                        if (lcAttr.ObjectNameToken != null)
                            lcObjectStr = lcAttr.ObjectNameToken.AsText;

                        lcIsColumnNotNull = CheckIsColumnNullTestFunction(lcSchemaStr, lcObjectStr, lcAttr.ColumnNameToken.AsText);
                    }
                }

            }

            if (lcIsColumnNotNull)
            {
                lcFuncExpr.AsText = lcFunc.ArgAsTextByIndex(0);
                pSelect.RawSqlText = pSelect.AsText;
                result = true;
            }
            else
            {

                // generate new where condition

                lcFuncExpr.AsText = lcFunc.ArgAsTextByIndex(0);
                lcStr = lcExpr.AsText;
                lcFuncExpr.AsText = lcFunc.ArgAsTextByIndex(1);
                lcStr2 = lcExpr.AsText;

                lcExpr.AsText = lcStr + " and " + lcFunc.ArgAsTextByIndex(0) + " is not null";
                lcStrList.Add(pSelect.AsText);

                lcExpr.AsText = lcStr2 + " and " + lcFunc.ArgAsTextByIndex(0) + " is null";
                lcStrList.Add(pSelect.AsText);

                lcStr = "";
                for (int i = 0; i < lcStrList.Count; i++)
                {
                    lcStr = lcStr + lcStrList[i];
                    if (i != lcStrList.Count - 1)
                        lcStr = lcStr + " union all ";
                }

                if (lcOrderByStr.Length > 0)
                    lcStr = lcStr + " order by " + lcOrderByStr;

                pSelect.RawSqlText = lcStr;
                result = true;
            }
            return result;
        }

        private bool CheckIsColumnNullTestFunction(string p_owner, string p_table_name, string p_column_name)
        {
            // hardcode, that segment1 is not null column, should rewrite this function yourself.
            return "segment1".Equals(p_column_name, StringComparison.OrdinalIgnoreCase);
        }

        private Boolean findNvlVisitor(TLz_Node pnode, Boolean pIsLeafNode)
        {
            TLzCustomExpression lcExpr, lcExpr1, lcExpr2;
            Boolean lcIsArg1Ok, lcIsArg2Ok;
            TLz_FuncCall lcFunc;
            Boolean result = true;

            if (pnode is TLzCustomExpression)
            {
                lcExpr = pnode as TLzCustomExpression;

                if (lcExpr.oper == TLzOpType.Expr_FuncCall)
                {
                    lcExpr.IsVisitSubTree = false;
                    lcFunc = lcExpr.lexpr as TLz_FuncCall;
                    if ("nvl".Equals(lcFunc.FunctionName, StringComparison.OrdinalIgnoreCase))
                    {
                        // at least one of params of nvl function must be column of table
                        lcIsArg1Ok = false;
                        lcIsArg2Ok = false;

                        if (lcFunc.args.Count() != 2)
                            return result;

                        if (lcFunc.args[0] is TLzCustomExpression)
                        {
                            lcExpr1 = lcFunc.args[0] as TLzCustomExpression;
                            lcIsArg1Ok = isColumnInExpr(lcExpr1);
                        }
                        if (lcFunc.args[1] is TLzCustomExpression)
                        {
                            lcExpr2 = lcFunc.args[1] as TLzCustomExpression;
                            lcIsArg2Ok = isColumnInExpr(lcExpr2);
                        }

                        if (lcIsArg1Ok || lcIsArg2Ok)
                        {
                            if (lcExpr.parentNode != null)
                            {
                                lcExpr.DummyTag = 3;//this is nvl we find
                                NodesToBeRewrited.Add(lcExpr.parentNode);
                                //result = false;
                            }
                        }
                    }
                }
                else if (lcExpr.oper == TLzOpType.Expr_OR)
                {
                    // GSP may bypass case #4 and case #6 when they are used with "OR" condition.
                    lcExpr.IsVisitSubTree = false; // don"t check sub expr inside this expr
                }

            }
            return result;
        }

        private Boolean isColumnInExpr(TLzCustomExpression ppExpr)
        {
            TSourceToken lcToken, lcStartToken, lcEndToken;
            TSourceTokenList lcTokenList;

            Boolean result = false;

            lcStartToken = ppExpr.StartToken;
            lcEndToken = ppExpr.EndToken;
            lcTokenList = lcStartToken.Container;
            if (!((lcStartToken != null) && (lcEndToken != null)))
                return result;
            if (lcTokenList == null) return result;

            for (int j = lcStartToken.posinlist; j <= lcEndToken.posinlist; j++)
            {
                lcToken = lcTokenList[j];
                result = lcToken.DBObjType == TDBObjType.ttObjField;
                if (result)
                {
                    result = !isColumnInGroupBy(lcToken.AsText, ((TSelectSqlStatement)gCurrentSql).GroupbyClause);
                    if (result)
                        break;
                }
            }
            return result;
        }

        private Boolean doRewriteSqlByRule5(TSelectSqlStatement pSelect,
 TLzCustomExpression pExpr)
        {
            TLzCustomExpression lcExpr;
            string lcOrderByStr, lcStr;
            List<string> lcStrList = new List<string>();


            lcOrderByStr = "";
            if (pSelect.SortClauseText.Length > 0)
            {
                lcOrderByStr = pSelect.SortClauseText;
                pSelect.SortClauseText = " ";
            }

            // generate new where condition

            lcExpr = pExpr;// NodesToBeRewrited[0]  as TLzCustomExpression;

            for (int i = 0; i < NodesToBeRewrited2.Count; i++)
            {
                lcExpr.IsParseAfterSetValue = false;
                lcExpr.AsText = ((TLzCustomExpression)NodesToBeRewrited2[i]).AsText;
                lcStrList.Add(pSelect.AsText);
            }

            lcStr = "";
            for (int i = 0; i < lcStrList.Count; i++)
            {
                lcStr = lcStr + lcStrList[i];
                if (i != lcStrList.Count - 1)
                    lcStr = lcStr + " union all ";
            }

            if (lcOrderByStr.Length > 0)
                lcStr = lcStr + " order by " + lcOrderByStr;

            pSelect.RawSqlText = lcStr;
            return true;
        }


        private Boolean doRewriteSqlByRule4(TSelectSqlStatement pSelect,
  TLzCustomExpression pExpr)
        {
            string lcOrderByStr;
            string lcStr;
            List<string> lcStrList = new List<string>();
            TLz_List lcList;


            lcOrderByStr = "";
            if (pSelect.SortClauseText.Length > 0)
            {
                lcOrderByStr = pSelect.SortClauseText;
                pSelect.SortClauseText = " ";
            }

            // generate new where condition
            lcList = new TLz_List(null);
            CommaExprToList(((TLzCustomExpression)pExpr.rexpr).lexpr as TLzCustomExpression, lcList);
            lcStr = pExpr.lexpr.AsText;
            for (int i = 0; i < lcList.Count(); i++)
            {
                pExpr.AsText = lcStr + " = " + ((TLzCustomExpression)lcList[i]).AsText;
                lcStrList.Add(pSelect.AsText);
            }

            lcStr = "";
            for (int i = 0; i < lcStrList.Count; i++)
            {
                lcStr = lcStr + lcStrList[i];
                if (i != lcStrList.Count - 1)
                    lcStr = lcStr + " union all ";
            }

            if (lcOrderByStr.Length > 0)
                lcStr = lcStr + " order by " + lcOrderByStr;

            pSelect.RawSqlText = lcStr;
            return true;
        }

        private Boolean findInExprVisitor(TLz_Node pnode, Boolean pIsLeafNode)
        {
            //  isExcluded : Boolean;
            TLzCustomExpression lcExpr, lcExpr2;
            //  subquery : TSelectSqlStatement;
            TLz_List lcList;

            if (pnode is TLzCustomExpression)
            {
                lcExpr = pnode as TLzCustomExpression;

                if (lcExpr.oper == TLzOpType.Expr_In)
                {
                    if (((TLzCustomExpression)lcExpr.rexpr).oper == TLzOpType.Expr_Parenthesis)
                    {
                        lcList = new TLz_List(null);

                        lcExpr2 = ((TLzCustomExpression)lcExpr.rexpr).lexpr as TLzCustomExpression;
                        if (lcExpr2.oper == TLzOpType.Expr_Comma)
                        {
                            CommaExprToList(lcExpr2, lcList);
                            // member in list must be less than 4 and more than 1
                            if ((lcList.Count() > 1) && (lcList.Count() <= Case4_MaxListValue))
                            {
                                // if column is in group by clause, passby it. Requested by epi in 2008-09-19
                                if (gCurrentSql is TSelectSqlStatement && ((TSelectSqlStatement)gCurrentSql).GroupbyClause != null)
                                {
                                    if (!isColumnInGroupBy(lcExpr.lexpr.AsText, ((TSelectSqlStatement)gCurrentSql).GroupbyClause))
                                        NodesToBeRewrited.Add(lcExpr);
                                }
                                else
                                    NodesToBeRewrited.Add(lcExpr);
                            }
                        }


                    }
                    lcExpr.IsVisitSubTree = false; // don"t check sub expr inside this expr
                }
                else if (lcExpr.oper == TLzOpType.Expr_OR)
                {
                    // GSP may bypass case #4 and case #6 when they are used with "OR" condition.
                    lcExpr.IsVisitSubTree = false; // don"t check sub expr inside this expr
                }

            }
            return true;
        }

        private Boolean findSubExprInOrExprVisitor(TLz_Node pnode, Boolean pIsLeafNode)
        {
            //  isExcluded : Boolean;
            TLzCustomExpression lcExpr;
            //  subquery : TSelectSqlStatement;
            //  lcList : Tlz_list;

            Boolean result = true;

            if (pnode is TLzCustomExpression)
            {
                lcExpr = pnode as TLzCustomExpression;

                if (lcExpr.oper == TLzOpType.Expr_OR)
                {
                    lcExpr.IsVisitSubTree = true;
                }
                else
                {
                    NodesToBeRewrited2.Add(lcExpr);
                    lcExpr.IsVisitSubTree = false; // don"t check sub expr inside this expr
                }

            }
            return result;
        }

        private Boolean findOrExprVisitor(TLz_Node pnode, Boolean pIsLeafNode)
        {
            TLzCustomExpression lcExpr;
            //  lcList : Tlz_list;

            Boolean result = true;

            if (pnode is TLzCustomExpression)
            {
                lcExpr = pnode as TLzCustomExpression;

                if (lcExpr.oper == TLzOpType.Expr_AND)
                {
                    lcExpr.IsVisitSubTree = true;
                }
                else if (lcExpr.oper == TLzOpType.Expr_Parenthesis)
                {
                    if (((TLzCustomExpression)lcExpr.lexpr).oper == TLzOpType.Expr_OR)
                    {
                        NodesToBeRewrited.Add(lcExpr);
                        lcExpr.IsVisitSubTree = false;
                    }
                    else
                        lcExpr.IsVisitSubTree = true;
                }
                else if (lcExpr.oper == TLzOpType.Expr_OR)
                {
                    NodesToBeRewrited.Add(lcExpr);
                    lcExpr.IsVisitSubTree = false;
                }
                else
                {
                    result = true;
                    lcExpr.IsVisitSubTree = false; // don"t check sub expr inside this expr
                }

            }

            return result;

        }


        private Boolean isColumnInGroupBy(string pColumnName, TLzGroupBy pGroupBy)
        {
            TSourceToken
              st, st1, st2;
            TSourceTokenList stlist;

            Boolean result = false;
            if (pGroupBy == null) return result;

            st1 = pGroupBy.StartToken;
            st2 = pGroupBy.EndToken;
            stlist = st1.Container;
            if (stlist == null) return result;
            for (int i = st1.posinlist; i <= st2.posinlist; i++)
            {
                st = stlist[i];
                if (st.DBObjType == TDBObjType.ttObjField)
                {
                    if (pColumnName.Equals(st.AsText))
                    {
                        result = true;
                        break;
                    }
                }
            }
            return result;
        }

        private Boolean IsRowNumInExpr(TLzCustomExpression pExpr)
        {
            TSourceToken
               lcToken, lcStartToken, lcEndToken;
            TSourceTokenList lcTokenList;
            Boolean result = false;
            if (pExpr == null) return result;

            lcStartToken = pExpr.StartToken;
            lcEndToken = pExpr.EndToken;
            lcTokenList = lcStartToken.Container;
            if (!(lcStartToken != null && lcEndToken != null)) return result;
            if (lcTokenList == null) return result;

            for (int j = lcStartToken.posinlist; j <= lcEndToken.posinlist; j++)
            {
                lcToken = lcTokenList[j];
                if (lcToken.TokenType == TTokenType.ttKeyWord)
                {
                    result = "rownum".Equals(lcToken.AsText, StringComparison.OrdinalIgnoreCase);
                    if (result) break;
                }
            }

            return result;

        }

        private bool doRewriteSqlByRule3_new(TSelectSqlStatement pSelect, TLzInlineViewOuterJoin pInlineViewOuterJoin)
        {
            TSelectSqlStatement lcsubquery2, lcsubquery3, lcSql;
            string lcOrderByStr;
            TLzTable lcCurrentTable, lcTable;
            TLzField lcField;
            string lcleftSqlStr, lcrightSqlStr, lcFieldStr, lcNewSubqueryStr, lcWhereStr;
            string lcrightSqlSelectListStr, lcrightSqlFromStr, lcrightSqlWhereStr, lctable1str;

            lcleftSqlStr = "";
            lcrightSqlStr = "";
            lcOrderByStr = "";
            lcrightSqlSelectListStr = "";
            lcrightSqlFromStr = "";
            lcrightSqlWhereStr = "";

            lcSql = pSelect;
            lcCurrentTable = pInlineViewOuterJoin.InlineView;

            // generate left side sql

            // modify where clause to remove (+) in outer join expression
            gAliasOfInlineView = lcCurrentTable.AliasClause.aliastext;
            NodesToBeRewrited3.Clear();
            lcSql.WhereClause.PreOrderTraverse(modifyOuterJoinExpr1Visitor);
            // remove order by clause in original sql to new create select sql
            if (lcSql.SortClause != null)
            {
                lcOrderByStr = lcSql.SortClauseText;
                lcSql.SortClauseText = " ";
            }

            lcleftSqlStr = lcSql.AsText;

            //restore this expression
            for (int k = 0; k < NodesToBeRewrited3.Count; k++)
            {
                ((TLzCustomExpression)NodesToBeRewrited3[k]).opname.AsText = ((TLzCustomExpression)NodesToBeRewrited3[k]).opname.PrevSourceCode;
            }

            // end of generate left side sql


            // genreate right side sql

            // get select list item
            for (int k = 0; k < lcSql.Fields.Count(); k++)
            {
                lcFieldStr = "";
                lcField = lcSql.Fields[k];
                if (lcField.FieldType == TLzFieldType.lftAttr)
                {
                    if (lcField.FieldAttr.ObjectNameToken != null)
                    {
                        if (lcField.FieldAttr.ObjectNameToken.AsText.Equals(lcCurrentTable.AliasClause.aliastext))
                        {
                            if (lcField.aliasclause != null)
                                lcFieldStr = "null " + lcField.aliasclause.aliastext;
                            else
                                lcFieldStr = "null " + lcField.FieldAttr.ColumnNameToken.AsText;
                        }
                    }
                }
                if (lcFieldStr.Length == 0)
                    lcFieldStr = lcField.AsText;

                lcrightSqlSelectListStr = lcrightSqlSelectListStr + lcFieldStr;
                if (k != lcSql.Fields.Count() - 1)
                    lcrightSqlSelectListStr = lcrightSqlSelectListStr + ",";
            }

            lcrightSqlStr = "select " + lcrightSqlSelectListStr;

            //get from clause

            // handle from clause without join
            //      for k = 0 to lcSql.Tables.Count - 1 do
            //        {
            //          if lcSql.Tables[k] = lcCurrentTable
            //            continue;
            //          if length(lcrightSqlFromStr) > 0
            //            lcrightSqlFromStr =  lcrightSqlFromStr + ",";
            //
            //          lcrightSqlFromStr =  lcrightSqlFromStr + lcSql.Tables[k].AsText;
            //        }
            // end handle from clause without join

            // handle from clause WITH join
            for (int k = 0; k < lcSql.JoinTables.Count(); k++)
            {
                lctable1str = "";

                if (lcSql.JoinTables[k].JoinTable != null)
                {
                    if (lcSql.JoinTables[k].JoinTable == lcCurrentTable)
                    {
                        if (lcSql.JoinTables[k].JoinItems.Count() > 0)
                        {
                            // (select ...) join tablea, need to remove (select ...)
                            continue;// need improve
                        }
                        else
                            continue;
                    }
                    else
                    {
                        lctable1str = lcSql.JoinTables[k].AsText;
                    }
                }


                if (lcrightSqlFromStr.Length > 0)
                    lcrightSqlFromStr = lcrightSqlFromStr + ",";

                lcrightSqlFromStr = lcrightSqlFromStr + lctable1str;
            }
            // end handle from clause WITH join

            lcrightSqlStr = lcrightSqlStr + " from " + lcrightSqlFromStr;

            // get where clause
            NodesToBeRewrited3.Clear();

            // remove outer join condition
            lcSql.WhereClause.PreOrderTraverse(modifyOuterJoinExpr2Visitor);
            lcrightSqlWhereStr = lcSql.WhereClause.AsText;

            //restore this expression
            for (int k = 0; k < NodesToBeRewrited3.Count; k++)
            {
                ((TLzCustomExpression)NodesToBeRewrited3[k]).IsParseAfterSetValue = false;
                ((TLzCustomExpression)NodesToBeRewrited3[k]).AsText = "";
            }


            if (lcrightSqlWhereStr.Trim().Length > 0)
                lcrightSqlWhereStr = lcrightSqlWhereStr + " and ";

            // { to construct not exists subquery

            // find table alias in outer join expression of top level from clause to rename conflict table alias in subquery
            aliasList.Clear();
            for (int m = 0; m < pInlineViewOuterJoin.OuterJoinExprs.Count; m++)
            {
                if (((TLzCustomExpression)pInlineViewOuterJoin.OuterJoinExprs[m].lexpr).oper != TLzOpType.Expr_OuterJoin)
                    ((TLzCustomExpression)pInlineViewOuterJoin.OuterJoinExprs[m].lexpr).PreOrderTraverse(FindAliasVisitor);
                else
                    ((TLzCustomExpression)pInlineViewOuterJoin.OuterJoinExprs[m].rexpr).PreOrderTraverse(FindAliasVisitor);
            }

            // if table alias is the same as the one in aliaslist, change it.
            lcsubquery3 = ((TSelectSqlStatement)pInlineViewOuterJoin.InlineView.SubQuery);
            // there maybe union in lcsubquerys, so find all subquery that need to be modified
            gTempStmts.Clear();
            findallstmts(lcsubquery3, true);

            for (int n = 0; n < gTempStmts.Count; n++)
            {
                lcsubquery2 = gTempStmts[n] as TSelectSqlStatement;

                for (int m = 0; m < aliasList.Count; m++)
                {
                    lcTable = GetTableInListByNameOrAlias(aliasList[m], lcsubquery2.Tables);
                    if (lcTable != null)
                    {
                        renameTableAliasByTable(lcsubquery2, lcTable, GenerateUniqueAlias(AliasPrefix, lcSql), false);
                    }
                }

                lcsubquery2.SelectClauseText = "1";
                if (lcsubquery2.GroupbyClause != null)
                    lcsubquery2.GroupbyClauseText = " ";

                lcWhereStr = "";

                // append outer join expr to where clause
                gTableList = lcsubquery2.Tables;
                gFieldList = lcsubquery2.Fields;

                for (int m = 0; m < pInlineViewOuterJoin.OuterJoinExprs.Count; m++)
                {
                    //lcTempExpr =  TLzCustomExpression.Create(self,dbvoracle,pInlineViewOuterJoin.OuterJoinExprs[m].AsText);

                    // modified attr that includes gAliasOfInlineView will be saved in NodesToBeRewrited3 for restore
                    NodesToBeRewrited3.Clear();

                    gAliasOfInlineView = pInlineViewOuterJoin.InlineView.AliasClause.aliastext;
                    pInlineViewOuterJoin.OuterJoinExprs[m].PreOrderTraverse(modifyOuterJoinExpr3Visitor);

                    if (lcWhereStr.Trim().Length > 0)
                        lcWhereStr = lcWhereStr + " and ";
                    lcWhereStr = lcWhereStr + pInlineViewOuterJoin.OuterJoinExprs[m].AsText;

                    // restore for use in next sql in union all
                    for (int t = 0; t < NodesToBeRewrited3.Count; t++)
                    {
                        ((TLz_Attr)NodesToBeRewrited3[t]).relname.AsText = ((TLz_Attr)NodesToBeRewrited3[t]).relname.PrevSourceCode;
                    }

                }

                if (lcsubquery2.WhereClauseText.Length > 0)
                    lcsubquery2.WhereClauseText = lcsubquery2.WhereClauseText + " and ";

                lcsubquery2.WhereClauseText = lcsubquery2.WhereClauseText + lcWhereStr;
            }


            lcNewSubqueryStr = lcsubquery3.AsText;

            // add outer join expr to where clause of not exists subquery

            lcrightSqlStr = lcrightSqlStr + " where " + lcrightSqlWhereStr + " not exists " + lcNewSubqueryStr;

            pSelect.RawSqlText = lcleftSqlStr + " union all " + lcrightSqlStr;
            if (lcOrderByStr.Length > 0)
                pSelect.RawSqlText = pSelect.RawSqlText + " order by " + lcOrderByStr;

            return true;

        }

        private bool modifyOuterJoinExpr3Visitor(TLz_Node pnode, Boolean pIsLeafNode)
        {
            TLzCustomExpression lcExpr, lcOuterJoinExpr;
            //  subquery : TSelectSqlStatement;
            TLz_Attr lcAttr;
            Boolean isFounded;

            lcOuterJoinExpr = null;
            if (pnode is TLzCustomExpression)
            {
                lcExpr = pnode as TLzCustomExpression;
                isFounded = false;

                if (lcExpr.opname != null)
                    if (lcExpr.opname.AsText.Equals("="))
                    {
                        if (lcExpr.lexpr is TLzCustomExpression)
                        {
                            if (((TLzCustomExpression)lcExpr.lexpr).oper == TLzOpType.Expr_OuterJoin)
                            {
                                isFounded = true;
                                lcOuterJoinExpr = (TLzCustomExpression)lcExpr.lexpr;
                            }

                        }

                        if (lcExpr.rexpr is TLzCustomExpression && !isFounded)
                        {
                            if (((TLzCustomExpression)lcExpr.rexpr).oper == TLzOpType.Expr_OuterJoin)
                                lcOuterJoinExpr = (TLzCustomExpression)lcExpr.rexpr;
                        }

                        if (lcOuterJoinExpr != null)
                        {
                            if (((TLzCustomExpression)lcOuterJoinExpr.lexpr).oper == TLzOpType.Expr_Attr)
                            {
                                lcAttr = ((TLzCustomExpression)lcOuterJoinExpr.lexpr).lexpr as TLz_Attr;
                                if (gAliasOfInlineView.Equals(lcAttr.Prefix))
                                {
                                    lcAttr.relname.PrevSourceCode = lcAttr.relname.AsText;
                                    NodesToBeRewrited3.Add(lcAttr);
                                    lcAttr.relname.AsText = FindPrefixOfThisColumnName(findColumnPrefix(lcAttr.lastname), lcAttr.lastname, gTableList);
                                    lcOuterJoinExpr.opname.AsText = "";
                                }

                            }
                        }

                        lcExpr.IsVisitSubTree = false; // don"t check sub expr inside this expr
                    }
            }
            return true;
        }

        private string FindPrefixOfThisColumnName(string pColumnPrefix, string pColumnName, TLzTableList pTableList)
        {
            TLzTable lcTable;

            string result = "";
            lcTable = TableListIncludeThisColumn(pColumnPrefix, pColumnName, pTableList);
            if (lcTable == null) return result;

            if (lcTable.AliasClause != null)
                result = lcTable.AliasClause.aliastext;
            else
                result = lcTable.TableName;
            return result;
        }

        private string findColumnPrefix(string pColumnName)
        {

            TLzField lcField;
            TLz_Attr llcAttr;

            string result = "";

            for (int i = 0; i < gFieldList.Count(); i++)
            {
                lcField = gFieldList[i];
                if (lcField.FieldType == TLzFieldType.lftAttr)
                {
                    llcAttr = lcField.FieldAttr;
                    if (llcAttr.ObjectNameToken != null)
                    {
                        if (pColumnName.Equals(llcAttr.ColumnNameToken.AsText))
                        {
                            result = llcAttr.ObjectNameToken.AsText;
                            break;
                        }
                    }
                }
            }
            return result;
        }

        private TLzTable GetTableInListByNameOrAlias(string pName, TLzTableList pTableList)
        {
            TLzTable lcTable;
            TLzTable result = null;
            for (int i = 0; i < pTableList.Count(); i++)
            {
                lcTable = pTableList[i];
                if (lcTable.AliasClause != null)
                {
                    if (lcTable.AliasClause.aliastext.Equals(pName, StringComparison.OrdinalIgnoreCase))
                    {
                        result = lcTable;
                        break;
                    }
                }

                if (lcTable.TableName.Equals(pName, StringComparison.OrdinalIgnoreCase))
                {
                    result = lcTable;
                    break;
                }
            }
            return result;
        }

        private bool FindAliasVisitor(TLz_Node pnode, Boolean pIsLeafNode)
        {
            TLzCustomExpression lcExpr;
            TLz_Attr lcAttr;
            if (pnode is TLzCustomExpression)
            {
                lcExpr = pnode as TLzCustomExpression;
                if (lcExpr.oper == TLzOpType.Expr_Attr)
                {
                    lcAttr = lcExpr.lexpr as TLz_Attr;
                    if (lcAttr.ObjectNameToken != null)
                    {
                        if (aliasList.IndexOf(lcAttr.ObjectNameToken.AsText) == -1)
                            aliasList.Add(lcAttr.ObjectNameToken.AsText);
                    }

                }
            }
            return true;
        }

        private bool modifyOuterJoinExpr2Visitor(TLz_Node pnode, Boolean pIsLeafNode)
        {
            TLzCustomExpression lcExpr, lcOuterJoinExpr;
            TLz_Attr lcAttr;
            Boolean isFounded;

            lcOuterJoinExpr = null;
            if (pnode is TLzCustomExpression)
            {
                lcExpr = pnode as TLzCustomExpression;
                isFounded = false;

                if (lcExpr.opname != null)
                    if (lcExpr.opname.AsText.Equals("="))
                    {
                        if (lcExpr.lexpr is TLzCustomExpression)
                        {
                            if (((TLzCustomExpression)lcExpr.lexpr).oper == TLzOpType.Expr_OuterJoin)
                            {
                                isFounded = true;
                                lcOuterJoinExpr = (TLzCustomExpression)lcExpr.lexpr;
                            }

                        }

                        if (lcExpr.rexpr is TLzCustomExpression && !isFounded)
                        {
                            if (((TLzCustomExpression)lcExpr.rexpr).oper == TLzOpType.Expr_OuterJoin)
                                lcOuterJoinExpr = (TLzCustomExpression)lcExpr.rexpr;
                        }

                        if (lcOuterJoinExpr != null)
                        {
                            if (((TLzCustomExpression)lcOuterJoinExpr.lexpr).oper == TLzOpType.Expr_Attr)
                            {
                                lcAttr = ((TLzCustomExpression)lcOuterJoinExpr.lexpr).lexpr as TLz_Attr;
                                if (gAliasOfInlineView.Equals(lcAttr.Prefix, StringComparison.OrdinalIgnoreCase))
                                {
                                    NodesToBeRewrited3.Add(lcExpr);
                                    lcExpr.OrigText = lcExpr.AsText;
                                    lcExpr.AsText = " ";
                                }
                            }
                        }
                        lcExpr.IsVisitSubTree = false; // don"t check sub expr inside this expr
                    }

            }
            return true;
        }

        private Boolean modifyOuterJoinExpr1Visitor(TLz_Node pnode, Boolean pIsLeafNode)
        {

            TLzCustomExpression lcExpr, lcOuterJoinExpr;
            //  subquery : TSelectSqlStatement;
            TLz_Attr lcAttr;
            Boolean isFounded;
            lcOuterJoinExpr = null;
            if (pnode is TLzCustomExpression)
            {
                lcExpr = pnode as TLzCustomExpression;
                isFounded = false;

                if (lcExpr.opname != null)
                    if (lcExpr.opname.AsText.Equals("="))
                    {
                        if (lcExpr.lexpr is TLzCustomExpression)
                        {
                            if (((TLzCustomExpression)lcExpr.lexpr).oper == TLzOpType.Expr_OuterJoin)
                            {
                                isFounded = true;
                                lcOuterJoinExpr = ((TLzCustomExpression)lcExpr.lexpr);
                            }

                        }

                        if (lcExpr.rexpr is TLzCustomExpression && !isFounded)
                        {
                            if (((TLzCustomExpression)lcExpr.rexpr).oper == TLzOpType.Expr_OuterJoin)
                                lcOuterJoinExpr = (TLzCustomExpression)lcExpr.rexpr;
                        }

                        if (lcOuterJoinExpr != null)
                        {
                            if (((TLzCustomExpression)lcOuterJoinExpr.lexpr).oper == TLzOpType.Expr_Attr)
                            {
                                lcAttr = ((TLzCustomExpression)lcOuterJoinExpr.lexpr).lexpr as TLz_Attr;
                                if (gAliasOfInlineView.Equals(lcAttr.Prefix))
                                {
                                    NodesToBeRewrited3.Add(lcOuterJoinExpr);
                                    lcOuterJoinExpr.opname.PrevSourceCode = lcOuterJoinExpr.opname.AsText;
                                    lcOuterJoinExpr.opname.AsText = "";
                                }
                            }
                        }

                        lcExpr.IsVisitSubTree = false; // don"t check sub expr inside this expr
                    }

            }
            return true;
        }

        private bool IsOuterJoinExprOfSubQuery(TLzCustomExpression pExpr, TLzTable pTable)
        {
            TLzCustomExpression lcExpr, lcOuterJoinExpr;
            TLz_Attr lcAttr;

            bool result = false;
            if (pTable.AliasClause == null) return result;
            lcOuterJoinExpr = null;
            if (((TLzCustomExpression)pExpr.lexpr).oper == TLzOpType.Expr_OuterJoin)
                lcOuterJoinExpr = (TLzCustomExpression)pExpr.lexpr;

            if (((TLzCustomExpression)pExpr.rexpr).oper == TLzOpType.Expr_OuterJoin)
                lcOuterJoinExpr = (TLzCustomExpression)pExpr.rexpr;

            if (lcOuterJoinExpr == null) return result;
            lcExpr = lcOuterJoinExpr.lexpr as TLzCustomExpression;

            if (lcExpr.oper != TLzOpType.Expr_Attr) return result;
            lcAttr = lcExpr.lexpr as TLz_Attr;

            if (lcAttr.ObjectNameToken != null)
            {
                if (lcAttr.ObjectNameToken.AsText.Equals(pTable.AliasClause.aliastext, StringComparison.OrdinalIgnoreCase))
                    result = true;
            }
            return result;
        }

        private bool findOuterJoinExprVisitor(TLz_Node pnode, Boolean pIsLeafNode)
        {
            bool isfounded;
            TLzCustomExpression lcExpr;
            if (pnode is TLzCustomExpression)
            {
                lcExpr = pnode as TLzCustomExpression;
                isfounded = false;

                if (lcExpr.opname != null)
                {
                    if (lcExpr.opname.AsText.Equals("="))
                    {
                        if (lcExpr.lexpr is TLzCustomExpression)
                        {
                            if (((TLzCustomExpression)lcExpr.lexpr).oper == TLzOpType.Expr_OuterJoin)
                            {
                                isfounded = true;
                                NodesToBeRewrited2.Add(lcExpr);
                            }
                        }

                        if (lcExpr.rexpr is TLzCustomExpression && !isfounded)
                        {
                            if (((TLzCustomExpression)lcExpr.rexpr).oper == TLzOpType.Expr_OuterJoin)
                            {
                                NodesToBeRewrited2.Add(lcExpr);
                            }
                        }
                        lcExpr.IsVisitSubTree = false; // don"t check sub expr inside this expr
                    }
                }
            }
            return true;
        }

        private bool doRewriteSqlByRule2(TCustomSqlStatement pSelect, TLzCustomExpression pExpr)
        {
            TSelectSqlStatement lcSubQuery;
            TLzCustomExpression lcLExpr, lcRExpr, lcPPExpr;
            TLz_Attr lcLAttr, lcRAttr;
            int listCount;
            string lcInStr, lcFieldStr, lcLAttrObjectStr, lcRAttrObjectStr;
            Boolean isNotExists;
            bool result = false;

            if (pExpr.oper != TLzOpType.Expr_Exists) return result;
            lcSubQuery = pExpr.rexpr as TSelectSqlStatement;
            if (lcSubQuery.WhereClause == null) return result;
            NodesToBeRewrited2.Clear();
            lcSubQuery.WhereClause.PreOrderTraverse(findEqualExprVisitor);
            if (NodesToBeRewrited2.Count == 0) return result;
            listCount = 0;
            lcInStr = "";
            lcFieldStr = "";
            for (int i = 0; i < NodesToBeRewrited2.Count; i++)
            {
                lcLExpr = ((TLzCustomExpression)NodesToBeRewrited2[i]).lexpr as TLzCustomExpression;
                lcRExpr = ((TLzCustomExpression)NodesToBeRewrited2[i]).rexpr as TLzCustomExpression;
                if (!(lcLExpr != null && lcRExpr != null)) continue;
                if (!(lcLExpr.oper == TLzOpType.Expr_Attr && lcRExpr.oper == TLzOpType.Expr_Attr)) continue;
                lcLAttr = lcLExpr.lexpr as TLz_Attr;
                lcRAttr = lcRExpr.lexpr as TLz_Attr;

                lcLAttrObjectStr = "";
                lcRAttrObjectStr = "";

                if (lcLAttr.ObjectNameToken != null)
                    lcLAttrObjectStr = lcLAttr.ObjectNameToken.AsText;

                if (lcRAttr.ObjectNameToken != null)
                    lcRAttrObjectStr = lcRAttr.ObjectNameToken.AsText;

                if (lcLAttrObjectStr.Length == 0 && lcRAttrObjectStr.Length == 0) continue;


                if (FindTableNameOrAlias(lcLAttrObjectStr, pSelect.Tables) != 0
                || FindTableNameOrAlias(lcRAttrObjectStr, lcSubQuery.Tables) != 0)
                {

                    if (listCount > 0)
                        lcInStr = lcInStr + ",";
                    lcInStr = lcInStr + lcLAttr.AsText;

                    if (listCount > 0)
                        lcFieldStr = lcFieldStr + ",";
                    lcFieldStr = lcFieldStr + lcRAttr.AsText;

                    listCount++;
                    //remove this condition from where clause
                    ((TLzCustomExpression)NodesToBeRewrited2[i]).AsText = " ";
                }
                else if (FindTableNameOrAlias(lcRAttrObjectStr, pSelect.Tables) != 0
                 || FindTableNameOrAlias(lcLAttrObjectStr, lcSubQuery.Tables) != 0)
                {

                    if (listCount > 0)
                        lcInStr = lcInStr + ",";
                    lcInStr = lcInStr + lcRAttr.AsText;

                    if (listCount > 0)
                        lcFieldStr = lcFieldStr + ",";
                    lcFieldStr = lcFieldStr + lcLAttr.AsText;

                    listCount++;
                    //remove this condition from where clause
                    ((TLzCustomExpression)NodesToBeRewrited2[i]).AsText = " ";
                }

            }

            if (listCount > 0)
            {

                // expr that need to be restored
                //NodesToBeRewrited3.Clear();

                if (listCount > 1)
                    lcInStr = "(" + lcInStr + ")";
                lcSubQuery.SelectClauseText = lcFieldStr;

                // check is this "not exists"
                isNotExists = false;
                if (pExpr.parentNode != null)
                {
                    lcPPExpr = pExpr.parentNode as TLzCustomExpression;
                    if (lcPPExpr.oper == TLzOpType.Expr_NOT)
                    {
                        // lcPPExpr.OrigText = lcPPExpr.AsText;
                        // NodesToBeRewrited3.Add(lcPPExpr);
                        lcPPExpr.AsText = lcInStr + " not in " + lcSubQuery.AsText;
                        isNotExists = true;
                    }
                }

                if (!isNotExists)
                {
                    // pExpr.OrigText = pExpr.AsText;
                    // NodesToBeRewrited3.Add(pExpr);
                    pExpr.AsText = lcInStr + " in " + lcSubQuery.AsText;
                }


                result = true;
            }
            return result;
        }

        private bool findEqualExprVisitor(TLz_Node pnode, Boolean pIsLeafNode)
        {
            TLzCustomExpression lcExpr;

            if (pnode is TLzCustomExpression)
            {
                lcExpr = pnode as TLzCustomExpression;

                if (lcExpr.opname != null)
                {
                    if (lcExpr.opname.AsText.Equals("="))
                    {

                        NodesToBeRewrited2.Add(lcExpr);
                        lcExpr.IsVisitSubTree = false; // don"t check sub expr inside this expr
                    }
                }
            }
            return true;
        }

        private bool findExistsSubQueryVisitor(TLz_Node pnode, Boolean pIsLeafNode)
        {
            bool isExcluded;
            TLzCustomExpression lcExpr, lcParentExpr, lcPParentExpr;
            TSelectSqlStatement subquery;
            if (pnode is TLzCustomExpression)
            {
                lcExpr = pnode as TLzCustomExpression;
                switch (lcExpr.oper)
                {
                    case TLzOpType.Expr_subquery:
                        lcExpr.IsVisitSubTree = false; // don"t check expr in subquery
                        break;
                    case TLzOpType.Expr_Exists:
                        isExcluded = false;
                        lcParentExpr = null;
                        if (lcExpr.parentNode != null)
                        {
                            lcParentExpr = lcExpr.parentNode as TLzCustomExpression;
                            if (lcParentExpr.oper == TLzOpType.Expr_OR)
                            {
                                isExcluded = true;
                            }
                            else if (lcParentExpr.oper == TLzOpType.Expr_NOT)
                            {
                                if (lcParentExpr.parentNode != null)
                                {
                                    lcPParentExpr = lcParentExpr.parentNode as TLzCustomExpression;
                                    if (lcPParentExpr.oper == TLzOpType.Expr_OR)
                                    {
                                        isExcluded = true;
                                    }
                                }
                            }
                        }

                        // exclude subquery has "unial all","minus","intersect"
                        if (!isExcluded)
                        {
                            subquery = lcExpr.rexpr as TSelectSqlStatement;
                            if (subquery.SelectSetType == TSelectSetType.sltUnion || subquery.SelectSetType == TSelectSetType.sltUnionAll || subquery.SelectSetType == TSelectSetType.sltMinus || subquery.SelectSetType == TSelectSetType.sltIntersect || subquery.SelectSetType == TSelectSetType.sltIntersectAll)
                                isExcluded = true;
                        }

                        if (!isExcluded)
                        {
                            if (lcParentExpr != null)
                            {
                                if (lcParentExpr.oper == TLzOpType.Expr_NOT)
                                {
                                    inquerys.Add(lcParentExpr);
                                }
                            }
                            NodesToBeRewrited.Add(lcExpr);
                        }
                        lcExpr.IsVisitSubTree = false; // don"t check sub expr inside this expr
                        break;
                }
            }
            return true;
        }

        private string format(string sql, TDbVendor vendor)
        {
            TGSqlParser sqlparser = new TGSqlParser(vendor);
            sqlparser.SqlText.Text = sql;
            if (sqlparser.PrettyPrint() == 0)
            {
                return sqlparser.FormattedSqlText.Text;
            }
            else
            {
                return sql;
            }
        }

        private bool doRewriteSqlByRule1(TCustomSqlStatement pSql, TLzCustomExpression pExpr)
        {
            Boolean result = false;
            if (!(pExpr.oper == TLzOpType.Expr_In || pExpr.oper == TLzOpType.Expr_NotIn || pExpr.oper == TLzOpType.Expr_Comparison)) return result;
            TLzCustomExpression lcLeftExpr = pExpr.lexpr as TLzCustomExpression;
            TSelectSqlStatement lcSubQuery = (TSelectSqlStatement)((TLzCustomExpression)pExpr.rexpr).lexpr;
            string lcNewConditionStr = "";
            if (lcLeftExpr.oper == TLzOpType.Expr_Attr)
            {
                if (!generateCondition(pSql, lcSubQuery, lcLeftExpr, lcSubQuery.Fields[0], out lcNewConditionStr))
                {
                    return result;
                }
            }
            else if (lcLeftExpr.oper == TLzOpType.Expr_Const)
            {
                if (!generateCondition(pSql, lcSubQuery, lcLeftExpr, lcSubQuery.Fields[0], out lcNewConditionStr))
                {
                    return result;
                }
            }
            else if (lcLeftExpr.oper == TLzOpType.Expr_Parenthesis)
            {
                TLz_List lcExprList = new TLz_List(null);
                CommaExprToList(lcLeftExpr.lexpr as TLzCustomExpression, lcExprList);
                for (int i = 0; i < lcExprList.Count(); i++)
                {
                    if (i == 0)
                    {
                        if (!generateCondition(pSql, lcSubQuery, lcExprList[i] as TLzCustomExpression, lcSubQuery.Fields[i], out lcNewConditionStr))
                        {
                            return result;
                        }
                    }
                    else
                    {
                        string lcNewConditionStr1;
                        if (generateCondition(pSql, lcSubQuery, lcExprList[i] as TLzCustomExpression, lcSubQuery.Fields[i], out lcNewConditionStr1))
                        {
                            lcNewConditionStr = lcNewConditionStr + " and " + lcNewConditionStr1;
                        }
                        else
                        {
                            return result;
                        }
                    }
                }
            }

            lcSubQuery.SelectClauseText = "1";

            if (lcSubQuery.WhereClause != null)
            {
                lcSubQuery.WhereClauseText = lcSubQuery.WhereClauseText + " and ";
            }

            lcSubQuery.WhereClauseText = lcSubQuery.WhereClauseText + lcNewConditionStr;


            if (pExpr.oper == TLzOpType.Expr_In || pExpr.oper == TLzOpType.Expr_Comparison)
            {
                pExpr.AsText = " exists " + lcSubQuery.AsText;
            }
            else if (pExpr.oper == TLzOpType.Expr_NotIn)
            {
                pExpr.AsText = " not exists " + lcSubQuery.AsText;
            }
            result = true;
            return result;
        }

        private void CommaExprToList(TLzCustomExpression pCommaExpr, TLz_List pList)
        {
            TLzCustomExpression lcexpr;
            if (pCommaExpr.oper != TLzOpType.Expr_Comma) return;
            pList.Add(pCommaExpr.lexpr);
            if (pCommaExpr.rexpr is TLzCustomExpression)
            {
                lcexpr = pCommaExpr.rexpr as TLzCustomExpression;

                while (lcexpr.oper == TLzOpType.Expr_Comma)
                {
                    pList.Add(lcexpr.lexpr);
                    if (lcexpr.rexpr is TLzCustomExpression)
                        lcexpr = lcexpr.rexpr as TLzCustomExpression;
                }
                if (lcexpr.oper != TLzOpType.Expr_Comma)
                    pList.Add(lcexpr);
            }
        }

        private bool generateCondition(TCustomSqlStatement pSql, TSelectSqlStatement lcSubQuery, TLzCustomExpression ppExpr, TLzField ppField, out string pConditionStr)
        {

            bool result = false;
            pConditionStr = "";
            if (!((ppExpr.oper == TLzOpType.Expr_Attr) || (ppExpr.oper == TLzOpType.Expr_Const))) return result;
            if (!(ppField.FieldType == TLzFieldType.lftAttr)) return result;

            string lcInStr = "";
            if (ppExpr.oper == TLzOpType.Expr_Attr)
            {
                TLz_Attr lcAttr = ppExpr.lexpr as TLz_Attr;
                string lcPrefixStr1 = "";
                TLzTable lcTable = null;
                if (lcAttr.ObjectNameToken == null)
                {
                    // field has no table or table alias prefix, syntax like : dept_no
                    lcTable = TableListIncludeThisColumn("", lcAttr.ColumnNameToken.AsText, pSql.Tables);
                    if (lcTable.AliasClause != null)
                    {
                        lcPrefixStr1 = lcTable.AliasClause.aliastext;
                    }
                    else
                    {
                        lcPrefixStr1 = lcTable.TableName;
                    }
                }
                else
                {
                    lcTable = TableListIncludeThisColumn(lcAttr.ObjectNameToken.AsText, lcAttr.ColumnNameToken.AsText, pSql.Tables);
                    lcPrefixStr1 = lcAttr.ObjectNameToken.AsText;
                }

                if (IsTableNameOrAliasInTableList(lcPrefixStr1, lcSubQuery.Tables))
                {
                    lcPrefixStr1 = GenerateUniqueAlias(AliasPrefix, pSql);
                    renameTableAliasByTable(pSql, lcTable, lcPrefixStr1, false);
                }

                if (lcAttr.ObjectNameToken != null)
                {
                    lcInStr = lcAttr.AsText;
                }
                else
                {
                    lcInStr = lcPrefixStr1 + "." + lcAttr.AsText;
                }
            }
            else if (ppExpr.oper == TLzOpType.Expr_Const)
            {
                lcInStr = ppExpr.AsText;
            }

            TLzField lcField = ppField;
            string lcPrefixStr2 = "";

            if (lcField.FieldType == TLzFieldType.lftAttr)
            {
                // check is there table prefix before this field, if no, find one
                TLz_Attr lcAttr2 = lcField.FieldAttr;
                if (lcAttr2.ObjectNameToken == null)
                {
                    TLzTable lcTable = TableListIncludeThisColumn("", lcAttr2.ColumnNameToken.AsText, lcSubQuery.Tables);

                    if (lcTable.AliasClause != null)
                    {
                        lcPrefixStr2 = lcTable.AliasClause.aliastext;
                    }
                    else
                    {
                        if (lcTable.TableType == TLzTableType.lttAttr)
                        {
                            lcPrefixStr2 = lcTable.AsText;
                        }
                        else if (lcTable.TableType == TLzTableType.lttSubquery)
                        {
                            lcPrefixStr2 = GenerateUniqueAlias(AliasPrefix, pSql);
                            lcTable.TableAlias = lcPrefixStr2;
                        }
                    }
                }
            }
            string lcFieldStr = "";
            if (lcPrefixStr2.Length > 0)
            {
                lcFieldStr = lcPrefixStr2 + "." + lcField.AsText;
            }
            else
            {
                lcFieldStr = lcField.AsText;
            }
            pConditionStr = (lcInStr + " = " + lcFieldStr);
            result = true;
            return result;
        }

        private void renameTableAliasByTable(TCustomSqlStatement pSql, TLzTable pTable, string pNewAlias, bool pIsPrefixAliasIfNotAlready)
        {
            renameTableAliasByName(pSql, pTable.TableName, pTable.TableAlias, pNewAlias, pIsPrefixAliasIfNotAlready);
        }

        private void DoRenameTableAlias(TCustomSqlStatement pTopSql, TCustomSqlStatement pCurrentSql, string pTableName, string pOldAlias, string pNewAlias, bool pIsPrefixAliasIfNotAlready)
        {

            TLzRenameTableAliasVisitor lcRv = new TLzRenameTableAliasVisitor(pCurrentSql);

            lcRv.CurrentSql = pCurrentSql;
            lcRv.TopSql = pTopSql;
            lcRv.TableName = pTableName;
            lcRv.OldAlias = pOldAlias;
            lcRv.NewAlias = pNewAlias;
            lcRv.IsPrefixAliasIfNotAlready = pIsPrefixAliasIfNotAlready;
            lcRv.go();

            for (int j = 0; j < pCurrentSql.ChildNodes.Count(); j++)
            {
                if (pCurrentSql.ChildNodes[j] is TSelectSqlStatement)
                {
                    DoRenameTableAlias(pTopSql, (TSelectSqlStatement)pCurrentSql.ChildNodes[j], pTableName, pOldAlias, pNewAlias, pIsPrefixAliasIfNotAlready);
                }
            }
        }



        private void renameTableAliasByName(TCustomSqlStatement pSql, string pTableName, string pOldAlias, string pNewAlias, bool pIsPrefixAliasIfNotAlready)
        {
            TLzTable lcTable = null;
            for (int i = 0; i < pSql.Tables.Count(); i++)
            {
                if (pTableName.Equals(pSql.Tables[i].TableName))
                {
                    if (pOldAlias.Length == 0)
                    {
                        lcTable = pSql.Tables[i];
                        break;
                    }
                    else
                    {
                        if (pSql.Tables[i].AliasClause == null)
                            continue;
                        if (pSql.Tables[i].AliasClause.aliastext.Equals(pOldAlias))
                        {
                            lcTable = pSql.Tables[i];
                            break;
                        }
                    }
                }
            }
            if (lcTable == null) return;
            DoRenameTableAlias(pSql, pSql, pTableName, pOldAlias, pNewAlias, pIsPrefixAliasIfNotAlready);
            if (lcTable.AliasClause != null)
                lcTable.AliasClause.AliasToken.AsText = pNewAlias;
            lcTable.TableAlias = pNewAlias;
        }

        private string GenerateUniqueAlias(string pOldAlias, TCustomSqlStatement pSql)
        {
            string result = "";
            for (int i = 1; i < 1000; i++)
            {
                result = pOldAlias + string.Format("{0:D3}", i);//+inttostr(i);
                if (IsUniqueTableAlias(result, pSql)) break;
            }
            return result;
        }

        private bool IsUniqueTableAlias(string ppAlias, TCustomSqlStatement ppSql)
        {
            TLzTableList llcTables = ppSql.Tables;
            bool isDuplicated = false;

            for (int lk = 0; lk < llcTables.Count(); lk++)
            {
                isDuplicated = ppAlias.Equals(llcTables[lk].TableName, StringComparison.OrdinalIgnoreCase);
                if (!isDuplicated && llcTables[lk].AliasClause != null)
                {
                    isDuplicated = ppAlias.Equals(llcTables[lk].AliasClause.aliastext, StringComparison.OrdinalIgnoreCase);
                }
                if (isDuplicated) break;
            }

            if (!isDuplicated)
            {
                for (int lk = 0; lk < ppSql.ChildNodes.Count(); lk++)
                {

                    if (ppSql.ChildNodes[lk] is TSelectSqlStatement)
                    {
                        isDuplicated = !IsUniqueTableAlias(ppAlias, ppSql.ChildNodes[lk] as TSelectSqlStatement);
                    }
                    if (isDuplicated) break;
                }
            }

            return !isDuplicated;
        }

        public static bool IsTableNameOrAliasInTableList(string pName, TLzTableList pTables)
        {
            return FindTableNameOrAlias(pName, pTables) != 0;
        }

        public static int FindTableNameOrAlias(string pName, TLzTableList pTableList)
        {
            int result = 0;
            for (int i = 0; i < pTableList.Count(); i++)
            {
                TLzTable lcTable = pTableList[i];
                if (lcTable.AliasClause != null)
                {
                    if (lcTable.AliasClause.aliastext.Equals(pName, StringComparison.OrdinalIgnoreCase))
                    {
                        result = 1;
                        break;
                    }
                }
                if (lcTable.TableName.Equals(pName, StringComparison.OrdinalIgnoreCase))
                {
                    result = 2;
                    break;
                }
            }
            return result;
        }

        private TLzTable TableListIncludeThisColumn(string pColumnPrefix, string pColumnText,
            TLzTableList pTableList)
        {
            TLzTable result = null;
            for (int i = 0; i < pTableList.Count(); i++)
            {
                result = TableIncludeThisColumn(pColumnPrefix, pColumnText, pTableList[i]);
                if (result != null) break;
            }
            return result;
        }

        private TLzTable TableIncludeThisColumn(string pColumnPrefix, string pColumnText, TLzTable pTable)
        {
            TLzTable result = null;
            if (pTable.AliasClause != null)
            {
                if (pColumnPrefix.Equals(pTable.AliasClause.aliastext, StringComparison.OrdinalIgnoreCase))
                {
                    result = pTable;
                }
                if (result == null)
                {
                    if (sketch_f_get_alias(pColumnPrefix, pTable.TableOwner, pTable.TableName, pColumnText))
                    {
                        result = pTable;
                    }
                }
            }
            else
            {
                if (sketch_f_get_alias(pColumnPrefix, pTable.TableOwner, pTable.TableName, pColumnText))
                {
                    result = pTable;
                }
            }
            return result;
        }

        private Boolean findInSubQueryVisitor(TLz_Node pnode, Boolean pIsLeafNode)
        {
            Boolean ret = true;
            TLzCustomExpression lcExpr;

            if (pnode is TLzCustomExpression)
            {
                lcExpr = pnode as TLzCustomExpression;
                switch (lcExpr.oper)
                {
                    case TLzOpType.Expr_subquery:
                        lcExpr.IsVisitSubTree = false;
                        break;
                    case TLzOpType.Expr_In:
                    case TLzOpType.Expr_NotIn:
                    case TLzOpType.Expr_Comparison:
                        if (((TLzCustomExpression)lcExpr.rexpr).oper == TLzOpType.Expr_subquery)
                        {
                            Boolean isExcluded = false;
                            if (lcExpr.parentNode != null)
                            {
                                TLzCustomExpression lcParentExpr = lcExpr.parentNode as TLzCustomExpression;
                                if (lcParentExpr.oper == TLzOpType.Expr_OR)
                                {
                                    TLzCustomExpression lexpr = (TLzCustomExpression)lcParentExpr.lexpr;
                                    TLzCustomExpression rexpr = (TLzCustomExpression)lcParentExpr.rexpr;
                                    if ((lexpr.oper == TLzOpType.Expr_IsNull || lexpr.oper == TLzOpType.Expr_IsNotNull)
                           || (rexpr.oper == TLzOpType.Expr_IsNull || rexpr.oper == TLzOpType.Expr_IsNotNull))
                                    {
                                        isExcluded = true;
                                    }
                                }
                            }

                            if (!isExcluded)
                            {
                                TSelectSqlStatement subquery = ((TLzCustomExpression)lcExpr.rexpr).lexpr as TSelectSqlStatement;
                                if (subquery.SelectSetType == TSelectSetType.sltUnion
                                    || subquery.SelectSetType == TSelectSetType.sltUnionAll
                                    || subquery.SelectSetType == TSelectSetType.sltMinus
                                    || subquery.SelectSetType == TSelectSetType.sltIntersect
                                    || subquery.SelectSetType == TSelectSetType.sltIntersectAll)
                                {
                                    isExcluded = true;
                                }
                            }
                            if (!isExcluded)
                            {
                                NodesToBeRewrited.Add(lcExpr);
                            }
                            lcExpr.IsVisitSubTree = false;
                        }
                        break;
                }
            }
            return ret;
        }

        private void findallstmts(TSelectSqlStatement select, bool isTemp)
        {
            if (select.SelectSetType != TSelectSetType.sltNone)
            {
                findallstmts(select.LeftStmt, isTemp);
                findallstmts(select.RightStmt, isTemp);
            }
            else
            {
                if (isTemp)
                {
                    gTempStmts.Add(select);
                }
                else
                {
                    gStmts.Add(select);
                }
            }
        }

        private void resetResult()
        {
            results.Clear();
            hintMessage = null;
            gStmts.Clear();
            gTempStmts.Clear();
        }
    }

    public class TLzRenameTableAliasVisitor : TLzVisitorAbs
    {
        int nestedLevel;
        TLz_Node parsetree;
        public string TableName, OldAlias, NewAlias;
        public bool IsPrefixAliasIfNotAlready;
        public TCustomSqlStatement CurrentSql, TopSql;

        public TLzRenameTableAliasVisitor(TLz_Node parsetree)
        {
            this.parsetree = parsetree;
        }


        public void go()
        {
            nestedLevel = 0;
            parsetree.Iterate(this);
        }

        public override void Execute(TLzVisitedAbs pVisited)
        {
            base.Execute(pVisited);
        }

        public override void PreExecute(TLzVisitedAbs pVisited)
        {
            if (pVisited is TSelectSqlStatement)
            {
                nestedLevel--;
            }
        }

        public override void PostExecute(TLzVisitedAbs pVisited)
        {
            TLz_Attr lcAttr = null;
            TCustomSqlStatement lcCurrentSql;

            if (pVisited is TLz_Attr)
            {
                if (nestedLevel == 1)
                {
                    lcAttr = pVisited as TLz_Attr;
                    if (CurrentSql == TopSql)
                    {
                        if (lcAttr.ColumnNameToken != null)
                        {
                            if (lcAttr.ObjectNameToken != null)
                            {
                                if (lcAttr.ObjectNameToken.AsText.Equals(TableName)
                                    || lcAttr.ObjectNameToken.AsText.Equals(OldAlias))
                                {
                                    lcAttr.ObjectNameToken.AsText = NewAlias;
                                }
                                else
                                {
                                    if (IsPrefixAliasIfNotAlready)
                                    {
                                        if (CurrentSql.Tables.Count() == 1)
                                        {
                                            lcAttr.ColumnNameToken.AsText = NewAlias + "." + lcAttr.ColumnNameToken.AsText;
                                        }
                                        else
                                        {
                                            if (sqlrewrite.sketch_f_get_alias("", "", TableName, lcAttr.ColumnNameToken.AsText))
                                                lcAttr.ColumnNameToken.AsText = NewAlias + "." + lcAttr.ColumnNameToken.AsText;
                                        }
                                    }
                                }
                            }
                        }
                        else
                        {
                            if (lcAttr.ObjectNameToken != null && lcAttr.ColumnNameToken != null)
                            {
                                if (lcAttr.ObjectNameToken.AsText.Equals(TableName)
                                    || lcAttr.ObjectNameToken.AsText.Equals(OldAlias))
                                {
                                    lcCurrentSql = CurrentSql;
                                    while (lcCurrentSql != TopSql)
                                    {
                                        if (sqlrewrite.IsTableNameOrAliasInTableList(lcAttr.ObjectNameToken.AsText, lcCurrentSql.Tables)) break;
                                        if (lcCurrentSql.OwnerStmt != null)
                                        {
                                            lcCurrentSql = lcCurrentSql.parentNode as TCustomSqlStatement;
                                        }
                                        else
                                            break;
                                    }
                                    if (lcCurrentSql == TopSql)
                                    {
                                        lcAttr.ObjectNameToken.AsText = NewAlias;
                                    }
                                }
                            }
                        }
                    }
                    else if (pVisited is TSelectSqlStatement)
                    {
                        nestedLevel++;
                    }
                }
            }
        }
    }

    public class TLzInlineViewOuterJoin
    {
        public TLzTable InlineView;
        public List<TLzCustomExpression> OuterJoinExprs = new List<TLzCustomExpression>();
    }

    public class TLzInlineViewOuterJoinArray
    {
        public List<TLzInlineViewOuterJoin> InlineViewOuterJoins = new List<TLzInlineViewOuterJoin>();

    }

    public class TLzTableHint
    {
        public string tableName;
        public string hintName;
        public string indexName;
        public TLzTableList tables = new TLzTableList(false);
    }

    public class TLzTableHintSql
    {
        public TCustomSqlStatement sql;
        public List<TLzTableHint> tableHintItems = new List<TLzTableHint>();
    }
}
